/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.maven.polyglot.PolyglotModelManager;
import org.sonatype.maven.polyglot.PolyglotPropertiesEnhancer;

@Component(role=ModelProcessor.class)
public class TeslaModelProcessor
implements ModelProcessor {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String WARNING = "?>" + NEW_LINE + "<!--" + NEW_LINE + NEW_LINE + NEW_LINE + "DO NOT MODIFIY - GENERATED CODE" + NEW_LINE + NEW_LINE + NEW_LINE + "-->";
    @Requirement
    private PolyglotModelManager manager;
    @Requirement
    private Logger log;

    public File locatePom(File dir) {
        assert (this.manager != null);
        File pomFile = this.manager.locatePom(dir);
        if (pomFile == null) {
            throw new AssertionError((Object)"pom file must not be null from PolyglotModelManager as per API");
        }
        if (pomFile.getName().equals("pom.xml") && pomFile.getParentFile().equals(dir)) {
            return pomFile;
        }
        File polyglotPomFile = new File(pomFile.getParentFile(), ".polyglot." + pomFile.getName());
        try {
            if (polyglotPomFile.createNewFile()) {
                polyglotPomFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error creating empty file", e);
        }
        return polyglotPomFile;
    }

    public Model read(File input, Map<String, ?> options) throws IOException, ModelParseException {
        Model model;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        try {
            model = this.read(reader, options);
            model.setPomFile(input);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return model;
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException, ModelParseException {
        return this.read(new InputStreamReader(input), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException, ModelParseException {
        assert (this.manager != null);
        ModelSource source = (ModelSource)options.get("org.apache.maven.model.building.source");
        if (("" + source).contains(".polyglot.")) {
            File dumpPom;
            this.log.debug(source.getLocation());
            File pom = new File(source.getLocation());
            source = new FileModelSource(new File(pom.getPath().replaceFirst("[.]polyglot[.]", "")));
            options.put("org.apache.maven.model.building.source", source);
            ModelReader reader = this.manager.getReaderFor(options);
            Model model = reader.read(source.getInputStream(), options);
            PolyglotPropertiesEnhancer.enhanceModel(this.manager.getEnhancementPropertiesFor(options), model);
            MavenXpp3Writer xmlWriter = new MavenXpp3Writer();
            StringWriter xml = new StringWriter();
            xmlWriter.write((Writer)xml, model);
            FileUtils.fileWrite((File)pom, (String)xml.toString());
            String dump = model.getProperties().getProperty("polyglot.dump.pom");
            if (dump == null) {
                dump = System.getProperty("polyglot.dump.pom");
            }
            if (!(dump == null || (dumpPom = new File(pom.getParentFile(), dump)).exists() && FileUtils.fileRead((File)dumpPom).equals(xml.toString().replace("?>", WARNING)))) {
                dumpPom.setWritable(true);
                FileUtils.fileWrite((File)dumpPom, (String)xml.toString().replace("?>", WARNING));
                if ("true".equals(model.getProperties().getProperty("polyglot.dump.readonly"))) {
                    dumpPom.setReadOnly();
                }
            }
            model.setPomFile(pom);
            return model;
        }
        ModelReader reader = this.manager.getReaderFor(options);
        return reader.read(input, options);
    }
}

