/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy;

import groovy.util.IndentPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.groovy.Dom2Groovy;
import org.sonatype.maven.polyglot.io.ModelWriterSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(role=ModelWriter.class, hint="groovy")
public class GroovyModelWriter
extends ModelWriterSupport {
    protected Logger log = LoggerFactory.getLogger(GroovyModelWriter.class);

    public void write(Writer output, Map<String, Object> options, Model model) throws IOException {
        assert (output != null);
        assert (model != null);
        StringWriter buff = new StringWriter();
        DefaultModelWriter writer = new DefaultModelWriter();
        writer.write((Writer)buff, options, model);
        Dom2Groovy converter = new Dom2Groovy(new IndentPrinter(new PrintWriter(output), "  "));
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(buff.toString())));
            Element root = doc.getDocumentElement();
            NamedNodeMap attrs = root.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                root.removeAttribute(attr.getName());
            }
            root.removeAttribute("xmlns:xsi");
            converter.print(doc);
            output.flush();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

