/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy.builder;

import groovy.lang.Closure;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.execute.ExecuteTask;
import org.sonatype.maven.polyglot.groovy.builder.factory.ChildFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.DependencyFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExcludesFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExclusionFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExclusionsFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExecuteFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExecutionFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExtensionsFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.GoalsFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.IncludesFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ListFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ModelFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ModulesFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.NamedFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ObjectFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ParentFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.PluginFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.PropertiesFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ReportSetsFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ReportingFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ReportsFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.StringFactory;

@Component(role=ModelBuilder.class)
public class ModelBuilder
extends FactoryBuilderSupport {
    protected Logger log = LoggerFactory.getLogger(ModelBuilder.class);
    private final Set<String> factoryNames = new HashSet<String>();
    private final Set<Class> factoryTypes = new HashSet<Class>();
    private final List<ExecuteTask> tasks = new ArrayList<ExecuteTask>();
    @Requirement
    private ExecuteManager executeManager;
    private ReportSet reportSet;

    public ModelBuilder() {
        this.registerFactories();
    }

    protected void setClosureDelegate(Closure c, Object o) {
        c.setDelegate((Object)this);
        c.setResolveStrategy(1);
    }

    public void setVariable(String name, Object value) {
        InvokerHelper.setProperty((Object)this.getCurrent(), (String)name, (Object)value);
    }

    public ExecuteManager getExecuteManager() {
        return this.executeManager;
    }

    public List<ExecuteTask> getTasks() {
        return this.tasks;
    }

    public void registerFactories() {
        this.registerStringFactory("module");
        this.registerStringFactory("filter");
        this.registerStringFactory("include");
        this.registerStringFactory("exclude");
        this.registerStringFactory("goal");
        this.registerStringFactory("role");
        this.registerStringFactory("otherArchive");
        this.registerStringFactory("activeByDefault");
        this.registerStringFactory("report");
        this.registerFactory(new PluginFactory());
        this.registerFactoriesFor(Plugin.class);
        this.registerFactory(new ModulesFactory());
        this.registerFactory(new ExclusionsFactory());
        this.registerFactory(new ExtensionsFactory());
        this.registerFactory(new IncludesFactory());
        this.registerFactory(new ExcludesFactory());
        this.registerFactory(new GoalsFactory());
        this.registerFactory(new ExecuteFactory());
        this.registerFactory(new ReportSetsFactory());
        this.registerFactory(new ReportsFactory());
        this.registerFactory(new ReportingFactory());
        this.registerFactoriesFor(Reporting.class);
        this.registerFactory(new ExecutionFactory());
        this.registerFactoriesFor(PluginExecution.class);
        this.registerFactory(new ModelFactory());
        this.registerFactoriesFor(Model.class);
        this.registerChildFactory("dependency", Dependency.class);
        this.registerChildFactory("exclusion", Exclusion.class);
        this.registerChildFactory("extension", Extension.class);
        this.registerChildFactory("resource", Resource.class);
        this.registerChildFactory("testResource", Resource.class);
        this.registerChildFactory("notifier", Notifier.class);
        this.registerChildFactory("contributor", Contributor.class);
        this.registerChildFactory("developer", Developer.class);
        this.registerChildFactory("license", License.class);
        this.registerChildFactory("mailingList", MailingList.class);
        this.registerChildFactory("profile", Profile.class);
        this.registerChildFactory("repository", DeploymentRepository.class);
        this.registerChildFactory("pluginRepository", Repository.class);
        this.registerChildFactory("reportSet", ReportSet.class);
        this.registerChildFactory("activation", Activation.class);
    }

    public void registerBeanFactory(String name, Class type) {
        super.registerBeanFactory(name, type);
        this.registerFactoriesFor(type);
    }

    public void registerFactory(String name, String groupName, Factory factory) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registering factory: " + name + ", factory: " + factory);
            if (this.factoryNames.contains(name)) {
                this.log.warn("Duplicate factory: " + name);
            }
        }
        this.factoryNames.add(name);
        super.registerFactory(name, groupName, factory);
    }

    private void registerFactory(NamedFactory factory) {
        assert (factory != null);
        this.registerFactory(factory.getName(), null, (Factory)factory);
    }

    private void registerChildFactory(String name, Class type) {
        this.registerFactory(this.createChildFactory(name, type));
        this.registerFactoriesFor(type);
    }

    private NamedFactory createChildFactory(String name, Class type) {
        assert (name != null);
        assert (type != null);
        if (type == Parent.class) {
            return new ParentFactory();
        }
        if (type == Dependency.class) {
            return new DependencyFactory();
        }
        if (type == Exclusion.class) {
            return new ExclusionFactory();
        }
        return new ChildFactory(name, type);
    }

    private void registerStringFactory(String name) {
        this.registerFactory(new StringFactory(name));
    }

    private void registerListFactory(String name) {
        this.registerFactory(new ListFactory(name));
    }

    private void registerPropertiesFactory(String name) {
        this.registerFactory(new PropertiesFactory(name));
    }

    private void registerObjectFactory(String name) {
        this.registerFactory(new ObjectFactory(name));
    }

    private void registerFactoriesFor(Class type) {
        Method[] methods;
        assert (type != null);
        if (this.factoryTypes.contains(type)) {
            return;
        }
        this.factoryTypes.add(type);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registering factories for type: " + type);
        }
        for (Method method : methods = type.getMethods()) {
            String name;
            if (!this.isSetter(method) || this.factoryNames.contains(name = this.propertyNameOf(method))) continue;
            Class<?> param = method.getParameterTypes()[0];
            if (param == String.class) {
                this.registerStringFactory(name);
                continue;
            }
            if (param == List.class) {
                this.registerListFactory(name);
                continue;
            }
            if (param == Properties.class) {
                this.registerPropertiesFactory(name);
                continue;
            }
            if (param == Object.class) {
                this.registerObjectFactory(name);
                continue;
            }
            if (param.getName().startsWith("org.apache.maven.model.")) {
                this.registerChildFactory(name, param);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Skipping setter with unsupported type: " + method);
        }
    }

    private boolean isSetter(Method method) {
        assert (method != null);
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getParameterTypes().length > 1) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        int m = method.getModifiers();
        return Modifier.isPublic(m) && !Modifier.isStatic(m);
    }

    private String propertyNameOf(Method method) {
        assert (method != null);
        String name = method.getName();
        name = name.substring(3, name.length());
        return new StringBuffer(name.length()).append(Character.toLowerCase(name.charAt(0))).append(name.substring(1)).toString();
    }

    public Object findInContext(String key) {
        for (Map ctx : this.getContexts()) {
            if (!ctx.containsKey(key)) continue;
            return ctx.get(key);
        }
        return null;
    }

    public ReportSet getReportSet() {
        return this.reportSet;
    }

    public void setReportSet(ReportSet reportSet) {
        this.reportSet = reportSet;
    }
}

