/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelWriter;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.PolyglotModelUtil;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.groovy.builder.ModelBuilder;
import org.sonatype.maven.polyglot.io.ModelReaderSupport;

@Named(value="groovy")
public class GroovyModelReader
extends ModelReaderSupport {
    protected Logger log = LoggerFactory.getLogger(GroovyModelReader.class);
    @Inject
    private ModelBuilder builder;
    @Inject
    private ExecuteManager executeManager;

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model model;
        assert (input != null);
        try {
            model = this.doRead(input, options);
        }
        catch (Throwable t) {
            t = StackTraceUtils.sanitize((Throwable)t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        this.executeManager.install(model, options);
        if (this.log.isDebugEnabled()) {
            DefaultModelWriter writer = new DefaultModelWriter();
            StringWriter buff = new StringWriter();
            writer.write((Writer)buff, null, model);
            this.log.debug("Read groovy model: \n" + buff);
        }
        return model;
    }

    private Model doRead(Reader input, Map<String, ?> options) throws IOException {
        assert (input != null);
        GroovyShell shell = new GroovyShell();
        String text = IOUtil.toString((Reader)input);
        String location = PolyglotModelUtil.getLocation(options);
        Script script = shell.parse(new GroovyCodeSource(text, location, location));
        assert (this.builder != null);
        return (Model)this.builder.build(script);
    }
}

