/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.io.ModelReaderSupport;
import org.sonatype.maven.polyglot.java.dsl.ModelFactory;

@Singleton
@Named(value="java")
public class JavaModelReader
extends ModelReaderSupport {
    @Inject
    private PlexusContainer container;
    protected Logger log = LoggerFactory.getLogger(JavaModelReader.class);

    private String getClassPath() {
        String pathSeparator = System.getProperty("path.separator", ":");
        StringBuilder sb = new StringBuilder();
        for (ClassRealm realm : this.container.getContainerRealm().getWorld().getRealms()) {
            if (realm.getId().contains("io.takari.polyglot:polyglot-java")) {
                for (URL jarURL : Arrays.asList(realm.getURLs())) {
                    if (sb.length() > 0) {
                        sb.append(pathSeparator);
                    }
                    sb.append(jarURL.getPath());
                }
            }
            if (!realm.getId().contains("plexus.core")) continue;
            for (URL jarURL : Arrays.asList(realm.getURLs())) {
                if (!jarURL.getPath().contains("commons-lang3") && !jarURL.getPath().contains("plexus-utils") && !jarURL.getPath().contains("maven-model-3")) continue;
                if (sb.length() > 0) {
                    sb.append(pathSeparator);
                }
                sb.append(jarURL.getPath().replaceAll("/bin/..", ""));
            }
        }
        String classPath = sb.toString();
        this.log.debug("Calculated classpath for dynamic POM.java compilation as " + classPath);
        return classPath;
    }

    private String replaceClassNameInSrc(String src, String className) {
        int classWordEnd = src.indexOf("class") + "class".length();
        int extendsStart = src.indexOf("extends");
        String newSrc = String.valueOf(src.substring(0, classWordEnd)) + " " + className + " " + src.substring(extendsStart, src.length());
        this.log.debug("Replaced class name to be " + className + " full src =" + newSrc);
        return newSrc;
    }

    private Model compileJavaCode(String src) {
        Model model = null;
        File tempDir = Files.createTempDir();
        String randomClassName = "POM" + UUID.randomUUID().toString().replaceAll("-", "");
        String filePath = tempDir.getAbsolutePath();
        if (!filePath.endsWith("/")) {
            filePath = String.valueOf(filePath) + "/";
        }
        filePath = String.valueOf(filePath) + randomClassName + ".java";
        try {
            Files.write((CharSequence)this.replaceClassNameInSrc(src, randomClassName), (File)new File(filePath), (Charset)Charset.defaultCharset());
            this.log.debug("Created temp file " + filePath + " to compile POM.java");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.debug("Error writing file " + filePath, (Throwable)e);
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        compiler.run(null, null, null, "-parameters", "-classpath", this.getClassPath(), filePath);
        this.log.debug("Dynamically compiled class " + filePath);
        try {
            try {
                URL comiledClassFolderURL = new URL("file:" + tempDir.getAbsolutePath() + "/");
                ClassRealm systemClassLoader = (ClassRealm)((Object)((Object)this)).getClass().getClassLoader();
                systemClassLoader.addURL(comiledClassFolderURL);
                this.log.debug("Added URL " + comiledClassFolderURL + " to Maven class loader to load class dynamically");
                Class<?> pomClass = Class.forName(randomClassName, false, (ClassLoader)systemClassLoader);
                model = ((ModelFactory)pomClass.newInstance()).getModel();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException e) {
                this.log.error("Failed to dynamically load class " + randomClassName, (Throwable)e);
                try {
                    FileUtils.deleteDirectory((File)tempDir);
                }
                catch (IOException e2) {
                    this.log.error("Failed to delete temp folder " + tempDir, (Throwable)e2);
                }
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempDir);
            }
            catch (IOException e) {
                this.log.error("Failed to delete temp folder " + tempDir, (Throwable)e);
            }
        }
        return model;
    }

    public Model read(Reader reader, Map<String, ?> options) throws IOException, ModelParseException {
        return this.compileJavaCode(this.readFile(reader));
    }

    private String readFile(Reader fileReader) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(fileReader);
            while ((line = reader.readLine()) != null) {
                content.append(line);
                content.append(System.lineSeparator());
            }
            reader.close();
            return content.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

