/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Resource;
import org.sonatype.maven.polyglot.java.dsl.BuildBaseBuilder;
import org.sonatype.maven.polyglot.java.dsl.PluginFactory;
import org.sonatype.maven.polyglot.java.dsl.ResourceBuilder;
import org.sonatype.maven.polyglot.java.dsl.ResourceDTO;
import org.sonatype.maven.polyglot.java.namedval.NamedValue;
import org.sonatype.maven.polyglot.java.namedval.NamedValueProcessor;

public interface BuildFactory
extends PluginFactory {
    default public BuildBaseBuilder profileBuild() {
        return new BuildBaseBuilder();
    }

    default public PluginManagementNamedValue pluginManagement(Plugin ... plugins) {
        PluginManagementNamedValue namedValue = new PluginManagementNamedValue();
        PluginManagement pluginManagement = new PluginManagement();
        if (plugins != null) {
            pluginManagement.setPlugins(Arrays.asList(plugins));
            namedValue.setPluginManagement(pluginManagement);
            return namedValue;
        }
        return null;
    }

    default public BuildFiltersNamedValue filters(String ... filters) {
        if (filters != null) {
            BuildFiltersNamedValue namedValue = new BuildFiltersNamedValue();
            namedValue.setFilters(Arrays.asList(filters));
            return namedValue;
        }
        return null;
    }

    default public BuildPluginsNamedValue plugins(Plugin ... plugins) {
        BuildPluginsNamedValue namedValue = new BuildPluginsNamedValue();
        if (plugins != null) {
            namedValue.setPlugins(Arrays.asList(plugins));
            return namedValue;
        }
        return null;
    }

    default public BuildExtensionNamedValue extensions(Extension ... extensions) {
        if (extensions != null) {
            BuildExtensionNamedValue namedValue = new BuildExtensionNamedValue();
            namedValue.setExtensions(Arrays.asList(extensions));
            return namedValue;
        }
        return null;
    }

    default public Extension extension(NamedValue ... keyValuePairs) {
        return NamedValueProcessor.namedToObject(new Extension(), keyValuePairs);
    }

    default public Extension extension(String groupId, String artifactId, String version) {
        Extension extension = new Extension();
        extension.setGroupId(groupId);
        extension.setArtifactId(artifactId);
        extension.setVersion(version);
        return extension;
    }

    default public Extension extension(String classifier) {
        Extension extension = new Extension();
        String[] parts = classifier.split(":");
        if (parts.length == 2) {
            extension.setGroupId(parts[0]);
            extension.setArtifactId(parts[1]);
        } else if (parts.length == 3) {
            extension.setVersion(parts[2]);
        }
        return extension;
    }

    default public ResourceBuilder resource() {
        return new ResourceBuilder();
    }

    default public Resource resource(String directory, String targetPath, boolean filtering, String[] includes, String[] excludes) {
        return this.resource(directory, targetPath, filtering, Arrays.asList(includes), Arrays.asList(excludes));
    }

    default public Resource resource(String directory, String targetPath, boolean filtering, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(directory);
        if (targetPath != null) {
            resource.setTargetPath(targetPath);
        }
        resource.setFiltering(filtering);
        if (includes != null) {
            resource.setIncludes(includes);
        }
        if (excludes != null) {
            resource.setExcludes(excludes);
        }
        return resource;
    }

    default public BuildResourcesNamedValue resources(Resource ... resources) {
        if (resources != null) {
            BuildResourcesNamedValue namedValue = new BuildResourcesNamedValue();
            namedValue.setResources(Arrays.asList(resources));
            return namedValue;
        }
        return null;
    }

    default public Resource resource(Consumer<ResourceDTO> resourceConsumer) {
        ResourceDTO resource = new ResourceDTO();
        resourceConsumer.accept(resource);
        return resource.getResource();
    }

    default public Resource resource(ResourcesNamedValue ... keyValuePairs) {
        Resource resource = new Resource();
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.asList(keyValuePairs).stream().filter(kvp -> kvp != null).filter(kvp -> !(kvp instanceof ResourcesIncludesNamedValue) && !(kvp instanceof ResourcesExcludesNamedValue)).forEach(kvp -> {
            String string = map.put(kvp.name(), kvp.value());
        });
        NamedValueProcessor.mapToObject(resource, map);
        Arrays.asList(keyValuePairs).stream().filter(kvp -> kvp != null).filter(kvp -> kvp instanceof ResourcesIncludesNamedValue).forEach(kvp -> resource.setIncludes(((ResourcesIncludesNamedValue)kvp).getIncludes()));
        Arrays.asList(keyValuePairs).stream().filter(kvp -> kvp != null).filter(kvp -> kvp instanceof ResourcesExcludesNamedValue).forEach(kvp -> resource.setIncludes(((ResourcesExcludesNamedValue)kvp).getExcludes()));
        return resource;
    }

    default public BuildTestResourcesNamedValue testResources(Resource ... resources) {
        if (resources != null) {
            BuildTestResourcesNamedValue namedValue = new BuildTestResourcesNamedValue();
            namedValue.setResources(Arrays.asList(resources));
            return namedValue;
        }
        return null;
    }

    default public ResourcesIncludesNamedValue includes(String ... includes) {
        ResourcesIncludesNamedValue namedValue = new ResourcesIncludesNamedValue();
        if (includes != null) {
            namedValue.setIncludes(Arrays.asList(includes));
        }
        return namedValue;
    }

    default public ResourcesExcludesNamedValue excludes(String ... excludes) {
        ResourcesExcludesNamedValue namedValue = new ResourcesExcludesNamedValue();
        if (excludes != null) {
            namedValue.setExcludes(Arrays.asList(excludes));
        }
        return namedValue;
    }

    public static interface BuildComplexTypeNamedValue
    extends BuildNamedValue {
    }

    public static class BuildExtensionNamedValue
    implements BuildComplexTypeNamedValue {
        private List<Extension> extensions;

        public List<Extension> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<Extension> extensions) {
            this.extensions = extensions;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static class BuildFiltersNamedValue
    implements BuildComplexTypeNamedValue {
        private List<String> filters;

        public List<String> getFilters() {
            return this.filters;
        }

        public void setFilters(List<String> filters) {
            this.filters = filters;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static interface BuildNamedValue
    extends NamedValue {
    }

    public static class BuildPluginsNamedValue
    implements BuildComplexTypeNamedValue {
        private List<Plugin> plugins;

        public List<Plugin> getPlugins() {
            return this.plugins;
        }

        public void setPlugins(List<Plugin> plugins) {
            this.plugins = plugins;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static class BuildResourcesNamedValue
    implements BuildComplexTypeNamedValue {
        private List<Resource> resources;

        public List<Resource> getResources() {
            return this.resources;
        }

        public void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static class BuildTestResourcesNamedValue
    implements BuildComplexTypeNamedValue {
        private List<Resource> resources;

        public List<Resource> getResources() {
            return this.resources;
        }

        public void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static class PluginManagementNamedValue
    implements BuildComplexTypeNamedValue {
        private PluginManagement pluginManagement;

        public PluginManagement getPluginManagement() {
            return this.pluginManagement;
        }

        public void setPluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static class ResourcesExcludesNamedValue
    implements ResourcesNamedValue {
        private List<String> excludes;

        public List<String> getExcludes() {
            return this.excludes;
        }

        public void setExcludes(List<String> excludes) {
            this.excludes = excludes;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static class ResourcesIncludesNamedValue
    implements ResourcesNamedValue {
        private List<String> includes = new ArrayList<String>();

        public List<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(List<String> includes) {
            this.includes = includes;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static interface ResourcesNamedValue
    extends NamedValue {
    }
}

