/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.java.dsl.DependencyFactory;
import org.sonatype.maven.polyglot.java.dsl.PluginBuilder;
import org.sonatype.maven.polyglot.java.dsl.PluginExecutionBuilder;
import org.sonatype.maven.polyglot.java.namedval.NamedValue;
import org.sonatype.maven.polyglot.java.namedval.NamedValueProcessor;
import org.sonatype.maven.polyglot.java.xml.ConfiugrationXmlBuilder;

public interface PluginFactory
extends DependencyFactory {
    default public PluginExecutionBuilder execution(String id) {
        return new PluginExecutionBuilder(id);
    }

    default public PluginExecutionBuilder execution(String id, String phase) {
        return new PluginExecutionBuilder(id, phase);
    }

    default public PluginExecutionBuilder execution(String phase, int priority) {
        return new PluginExecutionBuilder(phase, priority);
    }

    default public PluginExecutionBuilder execution(String id, String phase, int priority) {
        return new PluginExecutionBuilder(id, phase, priority);
    }

    default public PluginBuilder plugin(String groupId, String artifactId, String version) {
        return new PluginBuilder(groupId, artifactId, version);
    }

    default public PluginBuilder plugin(String groupId, String artifactId) {
        return new PluginBuilder(groupId, artifactId);
    }

    default public PluginBuilder plugin(String classifier) {
        return new PluginBuilder(classifier);
    }

    default public PluginExecutionGoalsNamedValue goals(String ... goals) {
        if (goals != null) {
            PluginExecutionGoalsNamedValue container = new PluginExecutionGoalsNamedValue();
            container.setGoals(Arrays.asList(goals));
            return container;
        }
        return null;
    }

    default public PluginBuilder.WrapperPluginBuilder plugin(PluginNamedValue ... namedValues) {
        Plugin plugin = new Plugin();
        HashMap<String, String> map = new HashMap<String, String>();
        PluginNamedValue[] pluginNamedValueArray = namedValues;
        int n = namedValues.length;
        int n2 = 0;
        while (n2 < n) {
            PluginNamedValue kvp = pluginNamedValueArray[n2];
            if (kvp instanceof ConfigurationNamedValue) {
                plugin.setConfiguration((Object)((ConfigurationNamedValue)kvp).getConfiguration());
            } else if (kvp instanceof ExecutionsNamedValue) {
                plugin.setExecutions(((ExecutionsNamedValue)kvp).getExecutions());
            } else if (kvp instanceof DependenciesNamedValue) {
                plugin.setDependencies(((DependenciesNamedValue)kvp).getDependencies());
            } else {
                map.put(kvp.name(), kvp.value());
                NamedValueProcessor.mapToObject(plugin, map);
            }
            ++n2;
        }
        return new PluginBuilder.WrapperPluginBuilder(plugin);
    }

    default public PluginNamedValue pluginDependencies(Dependency ... dependencies) {
        DependenciesNamedValue deps = new DependenciesNamedValue();
        deps.setDependencies(Arrays.asList(dependencies));
        return deps;
    }

    default public PluginNamedValue executions(PluginExecution ... executions) {
        ExecutionsNamedValue exec = new ExecutionsNamedValue();
        exec.setExecutions(Arrays.asList(executions));
        return exec;
    }

    default public PluginExecutionBuilder.WrapperPluginExecutionBuilder execution(PluginExecutionNamedValue ... namedValues) {
        PluginExecution execution = new PluginExecution();
        HashMap<String, String> map = new HashMap<String, String>();
        PluginExecutionNamedValue[] pluginExecutionNamedValueArray = namedValues;
        int n = namedValues.length;
        int n2 = 0;
        while (n2 < n) {
            PluginExecutionNamedValue kvp = pluginExecutionNamedValueArray[n2];
            if (kvp instanceof ConfigurationNamedValue) {
                execution.setConfiguration((Object)((ConfigurationNamedValue)kvp).getConfiguration());
            } else if (kvp instanceof PluginExecutionGoalsNamedValue) {
                execution.setGoals(((PluginExecutionGoalsNamedValue)kvp).getGoals());
            } else {
                map.put(kvp.name(), kvp.value());
                NamedValueProcessor.mapToObject(execution, map);
            }
            ++n2;
        }
        return new PluginExecutionBuilder.WrapperPluginExecutionBuilder(execution);
    }

    default public ConfiugrationXmlBuilder startXML() {
        return new ConfiugrationXmlBuilder().startXML();
    }

    default public ConfigurationNamedValue configuration(Xpp3Dom configuration) {
        ConfigurationNamedValue conf = new ConfigurationNamedValue();
        conf.setConfiguration(configuration);
        return conf;
    }

    public static class ConfigurationNamedValue
    implements PluginNamedValue,
    PluginExecutionNamedValue {
        private Xpp3Dom configuration;

        public Xpp3Dom getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Xpp3Dom configuration) {
            this.configuration = configuration;
        }

        @Override
        public String apply(String t) {
            return t;
        }
    }

    public static class DependenciesNamedValue
    implements PluginNamedValue {
        private List<Dependency> dependencies;

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public String apply(String t) {
            return t;
        }
    }

    public static class ExecutionsNamedValue
    implements PluginNamedValue {
        private List<PluginExecution> executions;

        public List<PluginExecution> getExecutions() {
            return this.executions;
        }

        public void setExecutions(List<PluginExecution> executions) {
            this.executions = executions;
        }

        @Override
        public String apply(String t) {
            return t;
        }
    }

    public static class PluginExecutionGoalsNamedValue
    implements PluginExecutionNamedValue {
        private List<String> goals;

        public List<String> getGoals() {
            return this.goals;
        }

        public void setGoals(List<String> goals) {
            this.goals = goals;
        }

        @Override
        public String apply(String str) {
            return str;
        }
    }

    public static interface PluginExecutionNamedValue
    extends NamedValue {
    }

    public static interface PluginNamedValue
    extends NamedValue {
    }
}

