/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.namedval;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;
import org.sonatype.maven.polyglot.java.namedval.DefaultValue;

public interface MethodFinder
extends Serializable {
    default public SerializedLambda serialized() {
        try {
            Method replaceMethod = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            replaceMethod.setAccessible(true);
            return (SerializedLambda)replaceMethod.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Class<?> getContainingClass() {
        try {
            String className = this.serialized().getImplClass().replaceAll("/", ".");
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Method method() {
        SerializedLambda lambda = this.serialized();
        Class<?> containingClass = this.getContainingClass();
        return Arrays.asList(containingClass.getDeclaredMethods()).stream().filter(method -> Objects.equals(method.getName(), lambda.getImplMethodName())).findFirst().orElseThrow(UnableToGuessMethodException::new);
    }

    default public Parameter parameter(int n) {
        return this.method().getParameters()[n];
    }

    default public Object defaultValueForParameter(int n) {
        return DefaultValue.ofType(this.parameter(n).getType());
    }

    public static class UnableToGuessMethodException
    extends RuntimeException {
    }
}

