/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;

public class DependencyDTO {
    public String groupId;
    public String artifactId;
    public String version;
    public String type = "jar";
    public String classifier;
    public String scope;
    public String systemPath;
    public List<String> exclusions;
    public boolean optional = false;

    public Dependency getDependency() {
        Dependency dependency = new Dependency();
        if (this.groupId != null) {
            dependency.setGroupId(this.groupId);
        }
        if (this.artifactId != null) {
            dependency.setArtifactId(this.artifactId);
        }
        if (this.version != null) {
            dependency.setArtifactId(this.artifactId);
        }
        if (this.type != null) {
            dependency.setType(this.type);
        }
        if (this.classifier != null) {
            dependency.setClassifier(this.classifier);
        }
        if (this.scope != null) {
            dependency.setScope(this.scope);
        }
        if (this.systemPath != null) {
            dependency.setSystemPath(this.systemPath);
        }
        if (this.exclusions != null) {
            for (String exclusionStr : this.exclusions) {
                String[] parts = exclusionStr.split(":");
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(parts[0]);
                exclusion.setArtifactId(parts[1]);
                dependency.addExclusion(exclusion);
            }
        }
        dependency.setOptional(this.optional);
        return dependency;
    }
}

