/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.sonatype.maven.polyglot.java.dsl.BuildBuilder;
import org.sonatype.maven.polyglot.java.dsl.BuildFactory;
import org.sonatype.maven.polyglot.java.dsl.DependencyDTO;
import org.sonatype.maven.polyglot.java.dsl.DependencyFactory;
import org.sonatype.maven.polyglot.java.dsl.ProfileBuilder;
import org.sonatype.maven.polyglot.java.dsl.PropertyFactory;
import org.sonatype.maven.polyglot.java.namedval.NamedValue;
import org.sonatype.maven.polyglot.java.namedval.NamedValueProcessor;

public class ModelFactory
implements DependencyFactory,
PropertyFactory,
BuildFactory {
    protected Model model = new Model();
    protected String modelVersion;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String packaging;
    protected String name;
    protected String description;
    protected String url;
    protected String inceptionYear;
    protected String modelEncoding;
    private Organization organization;
    private List licenses;
    private List developers;
    private List contributors;
    private List mailingLists;
    private Prerequisites prerequisites;
    private Scm scm;
    private IssueManagement issueManagement;
    private CiManagement ciManagement;
    private DistributionManagement distributionManagement;
    private Object reports;
    private Reporting reporting;

    public void parent(NamedValue ... keyValuePairs) {
        Parent parent = new Parent();
        parent = NamedValueProcessor.namedToObject(parent, keyValuePairs);
        this.model.setParent(parent);
    }

    public void repositories(Repository ... repositories) {
        Arrays.asList(repositories).forEach(repo -> this.model.addRepository(repo));
    }

    public void pluginRepositories(Repository ... repositories) {
        Arrays.asList(repositories).forEach(repo -> this.model.addPluginRepository(repo));
    }

    public void dependencies(Dependency ... dependencies) {
        Arrays.asList(dependencies).forEach(dep -> this.model.addDependency(dep));
    }

    public void dependencies(Consumer<DependencyDTO> ... dependencies) {
        if (dependencies != null) {
            for (Consumer<DependencyDTO> consumer : Arrays.asList(dependencies)) {
                DependencyDTO dto = new DependencyDTO();
                consumer.accept(dto);
                this.model.addDependency(dto.getDependency());
            }
        }
    }

    public void dependencyManagement(Dependency ... dependencies) {
        if (this.model.getDependencyManagement() == null) {
            DependencyManagement dependencyManagement = new DependencyManagement();
            dependencyManagement.setDependencies(new ArrayList());
            this.model.setDependencyManagement(dependencyManagement);
        }
        Arrays.asList(dependencies).forEach(dep -> this.model.getDependencyManagement().addDependency(dep));
    }

    public void dependencyManagement(Consumer<DependencyDTO> ... dependencies) {
        if (this.model.getDependencyManagement() == null) {
            DependencyManagement dependencyManagement = new DependencyManagement();
            dependencyManagement.setDependencies(new ArrayList());
            this.model.setDependencyManagement(dependencyManagement);
        }
        if (dependencies != null) {
            for (Consumer<DependencyDTO> consumer : Arrays.asList(dependencies)) {
                DependencyDTO dto = new DependencyDTO();
                consumer.accept(dto);
                this.model.getDependencyManagement().addDependency(dto.getDependency());
            }
        }
    }

    public BuildBuilder build() {
        return new BuildBuilder(this.model);
    }

    public void modules(String ... modules) {
        if (modules != null) {
            Arrays.asList(modules).forEach(module -> this.model.addModule(module));
        }
    }

    public void build(BuildFactory.BuildNamedValue ... namedValues) {
        Build build = new Build();
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.asList(namedValues).stream().filter(kvp -> kvp != null).filter(kvp -> !(kvp instanceof BuildFactory.BuildComplexTypeNamedValue)).forEach(kvp -> {
            String string = map.put(kvp.name(), kvp.value());
        });
        NamedValueProcessor.mapToObject(build, map);
        for (BuildFactory.BuildNamedValue namedvalue : Arrays.asList(namedValues)) {
            if (namedvalue instanceof BuildFactory.BuildPluginsNamedValue) {
                build.setPlugins(((BuildFactory.BuildPluginsNamedValue)namedvalue).getPlugins());
            }
            if (namedvalue instanceof BuildFactory.PluginManagementNamedValue) {
                build.setPluginManagement(((BuildFactory.PluginManagementNamedValue)namedvalue).getPluginManagement());
            }
            if (namedvalue instanceof BuildFactory.BuildExtensionNamedValue) {
                build.setExtensions(((BuildFactory.BuildExtensionNamedValue)namedvalue).getExtensions());
            }
            if (namedvalue instanceof BuildFactory.BuildFiltersNamedValue) {
                build.setFilters(((BuildFactory.BuildFiltersNamedValue)namedvalue).getFilters());
            }
            if (namedvalue instanceof BuildFactory.BuildResourcesNamedValue) {
                build.setResources(((BuildFactory.BuildResourcesNamedValue)namedvalue).getResources());
            }
            if (!(namedvalue instanceof BuildFactory.BuildTestResourcesNamedValue)) continue;
            build.setTestResources(((BuildFactory.BuildTestResourcesNamedValue)namedvalue).getResources());
        }
        this.model.setBuild(build);
    }

    public void properties(PropertyFactory.Property ... properties) {
        Arrays.asList(properties).forEach(prop -> this.model.addProperty(prop.getName(), prop.getValue()));
    }

    public ProfileBuilder profile(String id) {
        ProfileBuilder builder = new ProfileBuilder(this.model, id);
        return builder;
    }

    public void project() {
    }

    public Model getModel() {
        this.project();
        if (this.modelVersion != null) {
            this.model.setModelVersion(this.modelVersion);
        }
        if (this.groupId != null) {
            this.model.setGroupId(this.groupId);
        }
        if (this.artifactId != null) {
            this.model.setArtifactId(this.artifactId);
        }
        if (this.version != null) {
            this.model.setVersion(this.version);
        }
        if (this.packaging != null) {
            this.model.setPackaging(this.packaging);
        }
        if (this.name != null) {
            this.model.setName(this.name);
        }
        if (this.description != null) {
            this.model.setDescription(this.description);
        }
        if (this.url != null) {
            this.model.setUrl(this.url);
        }
        if (this.inceptionYear != null) {
            this.model.setInceptionYear(this.inceptionYear);
        }
        if (this.modelEncoding != null) {
            this.model.setModelEncoding(this.modelEncoding);
        }
        return this.model;
    }
}

