/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.java.dsl.PluginExecutionBuilder;

public class PluginBuilder {
    private Plugin plugin = new Plugin();

    public PluginBuilder(String groupId, String artifactId, String version) {
        this.plugin.setGroupId(groupId);
        this.plugin.setArtifactId(artifactId);
        this.plugin.setVersion(version);
    }

    public PluginBuilder(String groupId, String artifactId) {
        this.plugin.setGroupId(groupId);
        this.plugin.setArtifactId(artifactId);
    }

    public PluginBuilder(String classifier) {
        String[] parts = classifier.split(":");
        if (parts.length == 2) {
            this.plugin.setGroupId(parts[0]);
            this.plugin.setArtifactId(parts[1]);
        } else if (parts.length == 3) {
            this.plugin.setVersion(parts[2]);
        }
    }

    public PluginBuilder configuration(Xpp3Dom configuration) {
        if (configuration != null) {
            this.plugin.setConfiguration((Object)configuration);
        }
        return this;
    }

    public PluginBuilder extensions(boolean extensions) {
        this.plugin.setExtensions(extensions);
        return this;
    }

    public PluginBuilder inherited(boolean inherited) {
        this.plugin.setInherited(inherited);
        return this;
    }

    public PluginBuilder dependencies(Dependency ... dependencies) {
        if (dependencies != null) {
            this.plugin.setDependencies(Arrays.asList(dependencies));
        }
        return this;
    }

    public PluginBuilder executions(PluginExecutionBuilder ... builders) {
        if (builders != null) {
            for (PluginExecutionBuilder executionBuilder : Arrays.asList(builders)) {
                if (this.plugin.getExecutions() == null) {
                    this.plugin.setExecutions(new ArrayList());
                }
                this.plugin.addExecution(executionBuilder.get());
            }
        }
        return this;
    }

    public PluginBuilder endPlugin() {
        return this;
    }

    public Plugin get() {
        return this.plugin;
    }

    public static class WrapperPluginBuilder
    extends PluginBuilder {
        private Plugin plugin;

        public WrapperPluginBuilder(Plugin plugin) {
            super(null, null);
            this.plugin = plugin;
        }

        @Override
        public Plugin get() {
            return this.plugin;
        }
    }
}

