/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Resource;
import org.sonatype.maven.polyglot.java.dsl.PluginBuilder;
import org.sonatype.maven.polyglot.java.dsl.ResourceBuilder;
import org.sonatype.maven.polyglot.java.dsl.ResourceDTO;

public class BuildBaseBuilder {
    private BuildBase build = new BuildBase();

    protected BuildBase getBuild() {
        return this.build;
    }

    public BuildBaseBuilder defaultGoal(String defaultGoal) {
        if (defaultGoal != null) {
            this.getBuild().setDefaultGoal(defaultGoal);
        }
        return this;
    }

    public BuildBaseBuilder directory(String directory) {
        if (directory != null) {
            this.getBuild().setDirectory(directory);
        }
        return this;
    }

    public BuildBaseBuilder finalName(String finalName) {
        if (finalName != null) {
            this.getBuild().setFinalName(finalName);
        }
        return this;
    }

    public BuildBaseBuilder filters(String ... filters) {
        if (filters != null) {
            this.getBuild().setFilters(Arrays.asList(filters));
        }
        return this;
    }

    public BuildBaseBuilder resources(Resource ... resources) {
        if (resources != null) {
            if (this.getBuild().getResources() == null) {
                this.getBuild().setResources(new ArrayList());
            }
            for (Resource resource : Arrays.asList(resources)) {
                this.getBuild().addResource(resource);
            }
        }
        return this;
    }

    public BuildBaseBuilder resources(Consumer<ResourceDTO> ... resources) {
        if (resources != null) {
            if (this.getBuild().getResources() == null) {
                this.getBuild().setResources(new ArrayList());
            }
            for (Consumer<ResourceDTO> consumer : Arrays.asList(resources)) {
                ResourceDTO dto = new ResourceDTO();
                consumer.accept(dto);
                this.getBuild().addResource(dto.getResource());
            }
        }
        return this;
    }

    public BuildBaseBuilder resources(ResourceBuilder ... resourceBuilders) {
        if (resourceBuilders != null) {
            if (this.getBuild().getResources() == null) {
                this.getBuild().setResources(new ArrayList());
            }
            for (ResourceBuilder resourceBuilder : Arrays.asList(resourceBuilders)) {
                this.getBuild().addResource(resourceBuilder.endResource());
            }
        }
        return this;
    }

    public BuildBaseBuilder testResources(ResourceBuilder ... resourceBuilders) {
        if (resourceBuilders != null) {
            if (this.getBuild().getTestResources() == null) {
                this.getBuild().setTestResources(new ArrayList());
            }
            for (ResourceBuilder resourceBuilder : Arrays.asList(resourceBuilders)) {
                this.getBuild().addTestResource(resourceBuilder.endResource());
            }
        }
        return this;
    }

    public BuildBaseBuilder testResources(Resource ... testResources) {
        if (testResources != null) {
            if (this.getBuild().getTestResources() == null) {
                this.getBuild().setTestResources(new ArrayList());
            }
            for (Resource testResource : Arrays.asList(testResources)) {
                this.getBuild().addTestResource(testResource);
            }
        }
        return this;
    }

    public BuildBaseBuilder plugins(PluginBuilder ... builders) {
        if (builders != null) {
            if (this.getBuild().getPlugins() == null) {
                this.getBuild().setPlugins(new ArrayList());
            }
            Arrays.asList(builders).stream().forEach(builder -> this.getBuild().addPlugin(builder.get()));
        }
        return this;
    }

    public BuildBaseBuilder pluginManagement(PluginBuilder ... builders) {
        if (builders != null) {
            if (this.getBuild().getPluginManagement() == null) {
                this.getBuild().setPluginManagement(new PluginManagement());
                this.getBuild().getPluginManagement().setPlugins(new ArrayList());
            }
            Arrays.asList(builders).stream().forEach(builder -> this.getBuild().getPluginManagement().addPlugin(builder.get()));
        }
        return this;
    }

    public BuildBaseBuilder endBuild() {
        return this;
    }

    public BuildBase get() {
        return this.getBuild();
    }
}

