/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.Arrays;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.sonatype.maven.polyglot.java.dsl.BuildBaseBuilder;

public class BuildBuilder
extends BuildBaseBuilder {
    private Model model;
    private Build build;

    public BuildBuilder(Model model) {
        this.model = model;
    }

    protected Build getBuild() {
        if (this.build == null) {
            this.build = new Build();
            this.model.setBuild(this.build);
        }
        return this.build;
    }

    public BuildBuilder sourceDirectory(String sourceDirectory) {
        if (sourceDirectory != null) {
            this.getBuild().setSourceDirectory(sourceDirectory);
        }
        return this;
    }

    public BuildBuilder scriptSourceDirectory(String scriptSourceDirectory) {
        if (scriptSourceDirectory != null) {
            this.getBuild().setScriptSourceDirectory(scriptSourceDirectory);
        }
        return this;
    }

    public BuildBuilder testSourceDirectory(String testSourceDirectory) {
        if (testSourceDirectory != null) {
            this.getBuild().setTestSourceDirectory(testSourceDirectory);
        }
        return this;
    }

    public BuildBuilder outputDirectory(String outputDirectory) {
        if (outputDirectory != null) {
            this.getBuild().setOutputDirectory(outputDirectory);
        }
        return this;
    }

    public BuildBuilder testOutputDirectory(String testOutputDirectory) {
        if (testOutputDirectory != null) {
            this.getBuild().setTestOutputDirectory(testOutputDirectory);
        }
        return this;
    }

    public BuildBuilder extensions(Extension ... extensions) {
        if (extensions != null) {
            this.getBuild().setExtensions(Arrays.asList(extensions));
        }
        return this;
    }
}

