/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.sonatype.maven.polyglot.java.namedval.NamedValue;
import org.sonatype.maven.polyglot.java.namedval.NamedValueProcessor;

public interface DependencyFactory {
    default public Dependency dependency(NamedValue ... keyValuePairs) {
        Dependency dependency = new Dependency();
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.asList(keyValuePairs).stream().filter(kvp -> kvp != null).filter(kvp -> !(kvp instanceof DependencyExclusions)).forEach(kvp -> {
            String string = map.put(kvp.name(), kvp.value());
        });
        NamedValueProcessor.mapToObject(dependency, map);
        Arrays.asList(keyValuePairs).stream().filter(kvp -> kvp != null).filter(kvp -> kvp instanceof DependencyExclusions).forEach(excl -> ((DependencyExclusions)excl).getExclusions().forEach(exclusion -> dependency.addExclusion(exclusion)));
        return dependency;
    }

    default public Dependency dependency(String definition) {
        return this.dependency(definition, null);
    }

    default public Dependency compile(String definition) {
        return this.dependency(definition, "compile");
    }

    default public Dependency provided(String definition) {
        return this.dependency(definition, "provided");
    }

    default public Dependency runtime(String definition) {
        return this.dependency(definition, "runtime");
    }

    default public Dependency test(String definition) {
        return this.dependency(definition, "test");
    }

    default public Dependency dependency(String definition, String scope) {
        Dependency dependency = new Dependency();
        String[] parts = definition.split(":");
        dependency.setGroupId(parts[0]);
        dependency.setArtifactId(parts[1]);
        if (parts.length > 2) {
            dependency.setVersion(parts[3]);
        }
        if (scope != null) {
            dependency.setScope(scope);
        }
        return dependency;
    }

    default public Repository repository(String id, String name, String url) {
        return this.repository(id, name, url, null, null, null);
    }

    default public Repository repository(NamedValue ... keyValuePairs) {
        Repository repository = new Repository();
        NamedValueProcessor.namedToObject(repository, keyValuePairs);
        return repository;
    }

    default public Repository repository(String id, String name, String url, String layout, RepositoryPolicy releases, RepositoryPolicy snapshots) {
        Repository repository = new Repository();
        if (id != null) {
            repository.setId(id);
        }
        if (name != null) {
            repository.setName(name);
        }
        if (url != null) {
            repository.setUrl(url);
        }
        if (layout != null) {
            repository.setLayout(layout);
        }
        if (releases != null) {
            repository.setReleases(releases);
        }
        if (snapshots != null) {
            repository.setSnapshots(snapshots);
        }
        return repository;
    }

    default public RepositoryPolicy repositoryPolicy(boolean enabled, String updatePolicy, String checksumPolicy) {
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(enabled);
        if (updatePolicy != null) {
            policy.setUpdatePolicy(updatePolicy);
        }
        if (checksumPolicy != null) {
            policy.setChecksumPolicy(checksumPolicy);
        }
        return policy;
    }

    default public NamedValue exclusions(Exclusion ... exclusions) {
        DependencyExclusions depExclusions = new DependencyExclusions();
        depExclusions.setExclusions(exclusions);
        return depExclusions;
    }

    default public Exclusion exclusion(NamedValue ... keyValuePairs) {
        Exclusion exclusion = new Exclusion();
        return NamedValueProcessor.namedToObject(exclusion, keyValuePairs);
    }

    public static class DependencyExclusions
    implements NamedValue {
        private Exclusion[] exclusions;

        public Stream<Exclusion> getExclusions() {
            return Arrays.asList(this.exclusions).stream();
        }

        public void setExclusions(Exclusion[] exclusions) {
            this.exclusions = exclusions;
        }

        @Override
        public String apply(String t) {
            return t;
        }
    }
}

