/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.dsl;

import java.util.Arrays;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.sonatype.maven.polyglot.java.dsl.BuildBaseBuilder;
import org.sonatype.maven.polyglot.java.dsl.PropertyFactory;

public class ProfileBuilder {
    private Model model;
    private String id = "default";
    private BuildBase build;
    private DistributionManagement distributionManagement;
    private ActivationOS os;

    public ProfileBuilder(Model model, String id) {
        this.model = model;
        this.id = id;
    }

    public ProfileBuilder modules(String ... modules) {
        if (modules != null) {
            this.getProfile().setModules(Arrays.asList(modules));
        }
        return this;
    }

    public ProfileBuilder dependencies(Dependency ... dependencies) {
        if (dependencies != null) {
            this.getProfile().setDependencies(Arrays.asList(dependencies));
        }
        return this;
    }

    public ProfileBuilder dependencyManagement(Dependency ... dependencies) {
        if (dependencies != null) {
            DependencyManagement dependencyManagement = new DependencyManagement();
            dependencyManagement.setDependencies(Arrays.asList(dependencies));
            this.getProfile().setDependencyManagement(dependencyManagement);
        }
        return this;
    }

    public ProfileBuilder repositories(Repository ... repositories) {
        if (repositories != null) {
            this.getProfile().setRepositories(Arrays.asList(repositories));
        }
        return this;
    }

    public ProfileBuilder pluginRepositories(Repository ... pluginRepositories) {
        if (pluginRepositories != null) {
            this.getProfile().setPluginRepositories(Arrays.asList(pluginRepositories));
        }
        return this;
    }

    public ProfileBuilder properties(PropertyFactory.Property ... properties) {
        if (properties != null) {
            Arrays.asList(properties).forEach(prop -> this.getProfile().addProperty(prop.getName(), prop.getValue()));
        }
        return this;
    }

    public ProfileBuilder activeByDefault(boolean activeByDefault) {
        this.getActivation().setActiveByDefault(activeByDefault);
        return this;
    }

    public ProfileBuilder activeForJDK(String jdk) {
        this.getActivation().setJdk(jdk);
        return this;
    }

    public ProfileBuilder activeForPropertyValue(String name, String value) {
        ActivationProperty activationProperty = new ActivationProperty();
        activationProperty.setName(name);
        activationProperty.setValue(value);
        this.getActivation().setProperty(activationProperty);
        return this;
    }

    public ProfileBuilder activeForFile(String exists, String missing) {
        ActivationFile activationFile = new ActivationFile();
        if (exists != null) {
            activationFile.setExists(exists);
        }
        if (missing != null) {
            activationFile.setMissing(missing);
        }
        this.getActivation().setFile(activationFile);
        return this;
    }

    public ProfileBuilder build(BuildBaseBuilder buildBaseBuilder) {
        if (buildBaseBuilder != null) {
            this.build = buildBaseBuilder.get();
        }
        return this;
    }

    private Activation getActivation() {
        if (this.getProfile().getActivation() == null) {
            this.getProfile().setActivation(new Activation());
        }
        return this.getProfile().getActivation();
    }

    public ProfileBuilder endProfile() {
        return this;
    }

    private Profile getProfile() {
        Profile profile2;
        if (this.model.getProfiles() != null) {
            for (Profile profile2 : this.model.getProfiles()) {
                if (!profile2.getId().equals(this.id)) continue;
                return profile2;
            }
        }
        profile2 = new Profile();
        profile2.setId(this.id);
        this.model.addProfile(profile2);
        return profile2;
    }
}

