/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.java.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ModelToJavaWriter {
    private Writer out;
    private Model model;
    private String br = System.lineSeparator();

    public ModelToJavaWriter(Writer out, Model model) {
        this.out = out;
        this.model = model;
    }

    public void write() {
        try {
            this.writeFileStar();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFileStar() throws IOException {
        this.out.write("public class pom extends org.sonatype.maven.polyglot.java.dsl.ModelFactory {" + this.br);
        this.out.write("    public void project() {" + this.br);
        this.writeHeader();
    }

    private void writeFileEnd() throws IOException {
        this.out.write("    }" + this.br);
        this.out.write("}");
    }

    private void writeHeader() throws IOException {
        this.out.write("        modelVersion = \"" + this.model.getModelVersion() + "\";" + this.br);
        this.out.write("        groupId = \"" + this.model.getGroupId() + "\";" + this.br);
        this.out.write("        artifactId = \"" + this.model.getArtifactId() + "\";" + this.br);
        this.out.write("        packaging = \"" + this.model.getPackaging() + "\";" + this.br);
        this.out.write("        version = \"" + this.model.getVersion() + "\";" + this.br);
        this.writeParent();
    }

    private void writeParent() throws IOException {
        Parent parent = this.model.getParent();
        if (parent != null) {
            this.out.write("        parent(" + this.br);
            this.out.write("            groupId -> \"" + parent.getGroupId() + "\"," + this.br);
            this.out.write("            artifactId -> \"" + parent.getArtifactId() + "\"");
            if (parent.getVersion() != null) {
                this.out.write("," + this.br);
                this.out.write("            version -> \"" + parent.getVersion() + "\"");
            }
            if (parent.getRelativePath() != null) {
                this.out.write("," + this.br);
                this.out.write("            relativePath -> \"" + parent.getRelativePath() + "\"" + this.br);
            }
            this.out.write("        );" + this.br);
        }
        this.writeProperties();
    }

    private void writeProperties() throws IOException {
        Properties props = this.model.getProperties();
        if (props != null && !props.isEmpty()) {
            this.out.write("        properties(" + this.br);
            int propertyNumber = 1;
            for (Object prop : props.keySet()) {
                this.out.write("            property(\"" + prop.toString() + "\", \"" + props.get(prop) + "\")");
                if (propertyNumber < props.size()) {
                    this.out.write("," + this.br);
                } else {
                    this.out.write(this.br);
                }
                ++propertyNumber;
            }
            this.out.write("        );" + this.br);
        }
        this.writeRepositories();
    }

    private void writeRepositories() throws IOException {
        if (this.model.getRepositories() != null && !this.model.getRepositories().isEmpty()) {
            this.out.write("        repositories(" + this.br);
            int repositoryOrderNum = 1;
            for (Repository repository : this.model.getRepositories()) {
                this.out.write("            repository(");
                if (repository.getUrl() != null) {
                    this.out.write("url -> \"" + repository.getUrl() + "\"");
                }
                if (repository.getName() != null) {
                    this.out.write(", name -> \"" + repository.getName() + "\"");
                }
                if (repository.getId() != null) {
                    this.out.write(", id -> \"" + repository.getId() + "\"");
                }
                this.out.write(")" + this.br);
                if (repositoryOrderNum < this.model.getRepositories().size()) {
                    this.out.write("        ," + this.br);
                }
                ++repositoryOrderNum;
            }
            this.out.write("        );" + this.br);
        }
        this.writeDependencies();
    }

    private void writeDependencies() throws IOException {
        if (this.model.getDependencyManagement() != null && this.model.getDependencyManagement().getDependencies() != null && !this.model.getDependencyManagement().getDependencies().isEmpty()) {
            this.writeDependencies(this.model.getDependencyManagement().getDependencies(), "dependencyManagement");
        }
        this.writeDependencies(this.model.getDependencies(), "dependencies");
        this.writeBuild();
    }

    private void writeDependencies(List<Dependency> dependencies, String methodName) throws IOException {
        if (dependencies != null && !dependencies.isEmpty()) {
            this.out.write("        " + methodName + "(" + this.br);
            int dependencyNumber = 1;
            for (Dependency dependency : dependencies) {
                this.writeDependency(dependency, "        ");
                if (dependencyNumber < dependencies.size()) {
                    this.out.write("," + this.br);
                }
                ++dependencyNumber;
            }
            this.out.write(String.valueOf(this.br) + "        );" + this.br);
        }
    }

    private void writeDependency(Dependency dependency, String indent) throws IOException {
        this.out.write(String.valueOf(indent) + "    dependency(" + this.br);
        this.out.write(String.valueOf(indent) + "        groupId -> \"" + dependency.getGroupId() + "\"," + this.br);
        this.out.write(String.valueOf(indent) + "        artifactId -> \"" + dependency.getArtifactId() + "\"");
        if (dependency.getVersion() != null) {
            this.out.write("," + this.br);
            this.out.write(String.valueOf(indent) + "        version -> \"" + dependency.getVersion() + "\"");
        }
        if (dependency.getScope() != null) {
            this.out.write("," + this.br);
            this.out.write(String.valueOf(indent) + "        scope -> \"" + dependency.getScope() + "\"");
        }
        if (dependency.getOptional() != null) {
            this.out.write("," + this.br);
            this.out.write(String.valueOf(indent) + "        optional -> \"" + dependency.getOptional() + "\"");
        }
        if (dependency.getType() != null) {
            this.out.write("," + this.br);
            this.out.write(String.valueOf(indent) + "        type -> \"" + dependency.getType() + "\"");
        }
        if (dependency.getSystemPath() != null) {
            this.out.write("," + this.br);
            this.out.write(String.valueOf(indent) + "        systemPath -> \"" + dependency.getSystemPath() + "\"");
        }
        if (dependency.getExclusions() != null && !dependency.getExclusions().isEmpty()) {
            this.out.write("," + this.br);
            this.out.write(String.valueOf(indent) + "        exclusions(");
            for (Exclusion exclusion : dependency.getExclusions()) {
                this.out.write(String.valueOf(indent) + "        exclusion(groupId -> \"" + exclusion.getGroupId());
                if (exclusion.getArtifactId() != null) {
                    this.out.write(", artifactId -> \"" + exclusion.getArtifactId());
                }
                this.out.write("\")" + this.br);
            }
            this.out.write(String.valueOf(this.br) + indent + "    )");
        }
        this.out.write(String.valueOf(this.br) + indent + "    )");
    }

    private void writeBuild() throws IOException {
        Build build = this.model.getBuild();
        if (build != null) {
            List extensions;
            this.out.write("        build()" + this.br);
            if (build.getSourceDirectory() != null) {
                this.out.write("            .sourceDirectory(\"" + build.getSourceDirectory() + "\")" + this.br);
            }
            if (build.getScriptSourceDirectory() != null) {
                this.out.write("            .scriptSourceDirectory(\"" + build.getScriptSourceDirectory() + "\")" + this.br);
            }
            if (build.getTestSourceDirectory() != null) {
                this.out.write("            .testSourceDirectory(\"" + build.getTestSourceDirectory() + "\")" + this.br);
            }
            if (build.getOutputDirectory() != null) {
                this.out.write("            .outputDirectory(\"" + build.getOutputDirectory() + "\")" + this.br);
            }
            if (build.getTestOutputDirectory() != null) {
                this.out.write("            .testOutputDirectory(\"" + build.getTestOutputDirectory() + "\")" + this.br);
            }
            if ((extensions = build.getExtensions()) != null && !extensions.isEmpty()) {
                this.out.write("            .extensions(" + this.br);
                int extensionNumber = 1;
                for (Extension extension : extensions) {
                    this.out.write("                extension(" + this.br);
                    this.out.write("                    groupId -> \"" + extension.getGroupId() + "\"," + this.br);
                    this.out.write("                    artifactId -> \"" + extension.getArtifactId() + "\"");
                    if (extension.getVersion() != null) {
                        this.out.write("," + this.br);
                        this.out.write("                    version -> \"" + extension.getVersion() + "\"");
                    }
                    this.out.write(String.valueOf(this.br) + "                )");
                    if (extensionNumber < extensions.size()) {
                        this.out.write("," + this.br);
                    }
                    ++extensionNumber;
                }
                this.out.write(String.valueOf(this.br) + "            )" + this.br);
            }
            this.writeBuildBase((BuildBase)build, "            ");
            this.out.write("        .endBuild();" + this.br);
        }
        this.writeProfiles();
    }

    private void writeBuildBase(BuildBase build, String indent) throws IOException {
        if (build.getDefaultGoal() != null) {
            this.out.write(String.valueOf(indent) + ".defaultGoal(\"" + build.getDefaultGoal() + "\")" + this.br);
        }
        if (build.getDirectory() != null) {
            this.out.write(String.valueOf(indent) + ".directory(\"" + build.getDirectory() + "\")" + this.br);
        }
        if (build.getFinalName() != null) {
            this.out.write(String.valueOf(indent) + ".finalName(\"" + build.getFinalName() + "\")" + this.br);
        }
        if (build.getFilters() != null && !build.getFilters().isEmpty()) {
            this.out.write(String.valueOf(indent) + ".filters(\"" + build.getFilters().stream().collect(Collectors.joining("\",\"")) + "\")" + this.br);
        }
        if (build.getPluginManagement() != null) {
            this.writePlugins(build.getPluginManagement().getPlugins(), indent, "pluginManagement");
        }
        this.writePlugins(build.getPlugins(), indent, "plugins");
        this.writeResources(build.getResources(), indent, "resources");
        this.writeResources(build.getTestResources(), indent, "testResources");
    }

    private void writeResources(List<Resource> resources, String indent, String methodName) throws IOException {
        if (resources != null && !resources.isEmpty()) {
            this.out.write(String.valueOf(indent) + "." + methodName + "(" + this.br);
            int pluginOrderNum = 1;
            for (Resource resource : resources) {
                this.writeResource(resource, String.valueOf(indent) + "    ");
                if (pluginOrderNum < resources.size()) {
                    this.out.write(String.valueOf(indent) + "    ," + this.br);
                }
                ++pluginOrderNum;
            }
            this.out.write(String.valueOf(indent) + ")" + this.br);
        }
    }

    private void writeResource(Resource resource, String indent) throws IOException {
        this.out.write(String.valueOf(indent) + "resource()" + this.br);
        this.out.write(String.valueOf(indent) + "    ");
        if (resource.getDirectory() != null) {
            this.out.write(".directory(\"" + resource.getDirectory() + "\")");
        }
        if (resource.getFiltering() != null) {
            this.out.write(".filtering(" + resource.getFiltering() + ")");
        }
        if (resource.getTargetPath() != null) {
            this.out.write(".targetPath(\"" + resource.getTargetPath() + "\")");
        }
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            this.out.write(".includes(\"" + resource.getIncludes().stream().collect(Collectors.joining("\",\"")) + "\")");
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            this.out.write(".excludes(\"" + resource.getExcludes().stream().collect(Collectors.joining("\",\"")) + "\")");
        }
        this.out.write(String.valueOf(this.br) + indent + ".endResource()" + this.br);
    }

    private void writePlugins(List<Plugin> plugins, String indent, String methodName) throws IOException {
        if (plugins != null && !plugins.isEmpty()) {
            this.out.write(String.valueOf(indent) + "." + methodName + "(" + this.br);
            int pluginOrderNum = 1;
            for (Plugin plugin : plugins) {
                this.writePlugin(plugin, String.valueOf(indent) + "    ");
                if (pluginOrderNum < plugins.size()) {
                    this.out.write(String.valueOf(indent) + "    ," + this.br);
                }
                ++pluginOrderNum;
            }
            this.out.write(String.valueOf(indent) + ") //end of plugins section" + this.br);
        }
    }

    private void writePlugin(Plugin plugin, String indent) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(plugin.getGroupId()) + ":" + plugin.getArtifactId());
        if (plugin.getVersion() != null) {
            sb.append(":" + plugin.getVersion());
        }
        this.out.write(String.valueOf(indent) + "plugin(\"" + sb.toString() + "\")" + this.br);
        if (plugin.getExtensions() != null) {
            this.out.write(String.valueOf(indent) + "    .extensions(" + plugin.getExtensions() + ")" + this.br);
        }
        if (plugin.getInherited() != null) {
            this.out.write(String.valueOf(indent) + "    .inherited(" + plugin.getInherited() + ")" + this.br);
        }
        if (plugin.getDependencies() != null && !plugin.getDependencies().isEmpty()) {
            this.out.write(String.valueOf(indent) + "    " + ".dependencies(" + this.br);
            this.writePluginDependency(plugin.getDependencies(), indent);
            this.out.write(String.valueOf(indent) + "    " + ")" + this.br);
        }
        this.writeConfiguration((Xpp3Dom)plugin.getConfiguration(), indent);
        this.out.write(String.valueOf(indent) + ".endPlugin()" + this.br);
    }

    private void writeConfiguration(Xpp3Dom configuration, String indent) throws IOException {
        if (configuration != null) {
            this.out.write(String.valueOf(indent) + "    " + ".configuration(" + this.br);
            this.out.write(String.valueOf(indent) + "        " + "startXML()" + this.br);
            StringBuilder sb = new StringBuilder();
            this.generateConfig(configuration, sb, String.valueOf(indent) + "        ");
            this.out.write(sb.toString());
            this.out.write(String.valueOf(indent) + "        " + ".endXML()" + this.br);
            this.out.write(String.valueOf(indent) + "    " + ") // end of configuration section" + this.br);
        }
    }

    private void generateConfig(Xpp3Dom node, StringBuilder sb, String indent) {
        String tagName = node.getName();
        String tagValue = node.getValue();
        if (node.getParent() == null) {
            sb.append(String.valueOf(indent) + ".tag(\"" + tagName + "\", " + tagName + " -> {" + this.br);
        }
        if (tagValue != null) {
            sb.append(String.valueOf(indent) + "    " + this.calculateXMLIndent(node) + tagName + ".content(\"" + tagValue + "\");" + this.br);
        }
        String[] attributeNames = node.getAttributeNames();
        int i = 0;
        while (i < attributeNames.length) {
            String attributeName = attributeNames[i];
            sb.append(String.valueOf(indent) + this.calculateXMLIndent(node) + "    " + tagName + ".attribute(\"" + attributeName + "\", \"" + node.getAttribute(attributeName) + "\");" + this.br);
            ++i;
        }
        Xpp3Dom[] children = node.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            Xpp3Dom child = children[i2];
            sb.append(String.valueOf(indent) + this.calculateXMLIndent(child) + child.getParent().getName() + ".child(\"" + child.getName() + "\"," + child.getName() + " -> {" + this.br);
            this.generateConfig(child, sb, indent);
            sb.append(String.valueOf(indent) + this.calculateXMLIndent(child) + "});" + this.br);
            ++i2;
        }
        if (node.getParent() == null) {
            sb.append(String.valueOf(indent) + this.calculateXMLIndent(node) + "})" + this.br);
        }
    }

    private int calculateXMlHierarchyLevel(Xpp3Dom node, int level) {
        if (node.getParent() == null) {
            return level;
        }
        return this.calculateXMlHierarchyLevel(node.getParent(), level + 1);
    }

    private String calculateXMLIndent(Xpp3Dom node) {
        String indent = "";
        int i = 0;
        while (i < this.calculateXMlHierarchyLevel(node, 0)) {
            indent = String.valueOf(indent) + "    ";
            ++i;
        }
        return indent;
    }

    private void writePluginDependency(List<Dependency> dependencies, String indent) throws IOException {
        int dependencyNumber = 1;
        for (Dependency dependency : dependencies) {
            this.writeDependency(dependency, String.valueOf(indent) + "        ");
            this.out.write(this.br);
            if (dependencyNumber < dependencies.size()) {
                this.out.write(String.valueOf(indent) + "           ," + this.br);
            }
            ++dependencyNumber;
        }
    }

    private void writeProfiles() throws IOException {
        if (this.model.getProfiles() != null) {
            for (Profile profile : this.model.getProfiles()) {
                this.out.write("        profile(\"" + profile.getId() + "\")" + this.br);
                Activation activation = profile.getActivation();
                if (activation != null) {
                    this.out.write("            .activeByDefault(" + activation.isActiveByDefault() + ")" + this.br);
                    if (activation.getJdk() != null) {
                        this.out.write("            .activeByDefault(" + activation.isActiveByDefault() + ")" + this.br);
                    }
                    if (activation.getProperty() != null) {
                        String propertyValue = activation.getProperty().getValue() == null ? "null" : "\"" + activation.getProperty().getValue() + "\"";
                        this.out.write("            .activeForPropertyValue(\"" + activation.getProperty().getName() + "\"," + propertyValue + ")" + this.br);
                    }
                    if (activation.getFile() != null) {
                        String exists = activation.getFile().getExists() == null ? "null" : "\"" + activation.getFile().getExists() + "\"";
                        String missing = activation.getFile().getMissing() == null ? "null" : "\"" + activation.getFile().getMissing() + "\"";
                        this.out.write("            .activeForFile(" + exists + "," + missing + ")" + this.br);
                    }
                }
                if (profile.getBuild() != null) {
                    this.out.write("            .build(" + this.br);
                    this.out.write("                profileBuild()" + this.br);
                    this.writeBuildBase(profile.getBuild(), "                    ");
                    this.out.write("                .endBuild()" + this.br);
                    this.out.write("            ) //end of profile build section" + this.br);
                }
                this.out.write("        .endProfile();" + this.br);
            }
        }
        this.writeFileEnd();
    }
}

