/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.kotlin.engine;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.annotations.KotlinScript;
import kotlin.script.templates.ScriptTemplateDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonatype.maven.polyglot.execute.ExecuteContext;
import org.sonatype.maven.polyglot.kotlin.dsl.PomDsl;
import org.sonatype.maven.polyglot.kotlin.dsl.Project;
import org.sonatype.maven.polyglot.kotlin.engine.ScriptDefinition;
import org.sonatype.maven.polyglot.kotlin.engine.ScriptHost;

@KotlinScript(displayName="Maven kotlin POM script", fileExtension="pom.kts", compilationConfiguration=ScriptDefinition.class)
@ScriptTemplateDefinition(scriptFilePattern="pom\\.kts")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\b\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u0012\u0010\u0015\u001a\u00020\u0013*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/sonatype/maven/polyglot/kotlin/engine/PomKtsScript;", "", "script", "Ljava/io/File;", "basedir", "model", "Lorg/sonatype/maven/polyglot/kotlin/dsl/Project;", "<init>", "(Ljava/io/File;Ljava/io/File;Lorg/sonatype/maven/polyglot/kotlin/dsl/Project;)V", "getScript", "()Ljava/io/File;", "getBasedir", "getModel", "()Lorg/sonatype/maven/polyglot/kotlin/dsl/Project;", "project", "nameOrId", "", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "eval", "Lorg/sonatype/maven/polyglot/execute/ExecuteContext;", "taskScript", "polyglot-kotlin"})
public abstract class PomKtsScript {
    @NotNull
    private final File script;
    @NotNull
    private final File basedir;
    @NotNull
    private final Project model;

    public PomKtsScript(@NotNull File script, @NotNull File basedir, @NotNull Project model) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.script = script;
        this.basedir = basedir;
        this.model = model;
    }

    @NotNull
    public final File getScript() {
        return this.script;
    }

    @NotNull
    public final File getBasedir() {
        return this.basedir;
    }

    @NotNull
    public final Project getModel() {
        return this.model;
    }

    @PomDsl
    @NotNull
    public final Project project(@Nullable String nameOrId, @NotNull Function1<? super Project, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (nameOrId != null) {
            this.model.setName(nameOrId);
            this.model.setId(nameOrId);
        }
        Project project = this.model;
        block.invoke((Object)project);
        return project;
    }

    public static /* synthetic */ Project project$default(PomKtsScript pomKtsScript, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: project");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return pomKtsScript.project(string, (Function1<? super Project, Unit>)function1);
    }

    public final void eval(@NotNull File script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ScriptHost.INSTANCE.eval(script, this.basedir, this.model);
    }

    public final void eval(@NotNull ExecuteContext $this$eval, @NotNull File taskScript) {
        Intrinsics.checkNotNullParameter((Object)$this$eval, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)taskScript, (String)"taskScript");
        ScriptHost.INSTANCE.eval(taskScript, $this$eval);
    }
}

