/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.kotlin.serialization;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonatype.maven.polyglot.kotlin.dsl.DSLSupportKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001:\u0002LMB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\nH\u0004J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u001e\u0010\u001d\u001a\u00020\u00002\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001fH\u0004J\b\u0010 \u001a\u00020\u0000H\u0004J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\nH\u0004J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\nH\u0004Jo\u0010$\u001a\u00020%\"\b\b\u0000\u0010&*\u00020\u00012\u0006\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u0001H&2'\b\u0002\u0010)\u001a!\u0012\u0004\u0012\u0002H&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010+\u0012\u0004\u0012\u00020%\u0018\u00010*\u00a2\u0006\u0002\b,2\u001b\b\u0002\u0010-\u001a\u0015\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%\u0018\u00010.\u00a2\u0006\u0002\b,H\u0004\u00a2\u0006\u0002\u0010/Jw\u0010$\u001a\u00020%\"\b\b\u0000\u0010&*\u00020\u00012\u0006\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u0001H&2\u0006\u00100\u001a\u00020\n2'\b\u0002\u0010)\u001a!\u0012\u0004\u0012\u0002H&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010+\u0012\u0004\u0012\u00020%\u0018\u00010*\u00a2\u0006\u0002\b,2\u001b\b\u0002\u0010-\u001a\u0015\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%\u0018\u00010.\u00a2\u0006\u0002\b,H\u0004\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u00020%2\b\u00103\u001a\u0004\u0018\u00010\nH\u0004J\u0012\u00104\u001a\u00020%2\b\u00103\u001a\u0004\u0018\u00010\nH\u0002J\b\u00105\u001a\u00020\u0000H\u0002J\b\u00106\u001a\u00020\u0000H\u0002J \u00107\u001a\u00020\u00002\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\n2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\nH\u0002J\b\u00108\u001a\u00020\u0000H\u0002J\u0010\u00109\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\nH\u0002J\b\u0010:\u001a\u00020\u0000H\u0002J\u0010\u0010;\u001a\u00020%2\u0006\u0010'\u001a\u00020\nH\u0002J\b\u0010<\u001a\u00020%H\u0002J\b\u0010=\u001a\u00020%H\u0002J\b\u0010>\u001a\u00020%H\u0002J\u0018\u0010?\u001a\u00020%2\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0AH\u0004J$\u0010B\u001a\u00020%2\u001a\u0010C\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001f0AH\u0002J\u0018\u0010D\u001a\u00020%2\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0AH\u0002J$\u0010E\u001a\u00020%2\u001a\u0010C\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001f0AH\u0002J\u001e\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0HH\u0004J\u001e\u0010I\u001a\u00020%2\u0006\u0010J\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0HH\u0004J\u0016\u0010K\u001a\u00020%2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0HH\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter;", "", "writer", "Ljava/io/Writer;", "<init>", "(Ljava/io/Writer;)V", "state", "Ljava/util/Deque;", "Lorg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter$SerializerState;", "indentation", "", "indentLevel", "", "getIndentLevel", "()I", "setIndentLevel", "(I)V", "lineStart", "", "argumentWrapThreshold", "out", "Lorg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter$OUT;", "expressionText", "Lkotlin/text/Regex;", "booleanLiteral", "write", "str", "writeString", "value", "writePair", "pair", "Lkotlin/Pair;", "endLine", "blockComment", "comment", "lineComment", "block", "", "T", "name", "modelObject", "args", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "contents", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "paramName", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "singleQuotedString", "text", "tripleQuotedString", "incrementIndent", "decrementIndent", "startBlock", "endBlock", "startFunction", "endFunction", "startField", "endField", "startMultiLineString", "endMultiLineString", "arguments", "values", "", "namedArguments", "pairs", "multiLineArguments", "namedMultiLineArguments", "field", "fieldName", "Lkotlin/Function0;", "function", "functionName", "multiLineString", "SerializerState", "OUT", "polyglot-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinScriptWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinScriptWriter.kt\norg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1869#2,2:320\n1869#2,2:322\n1869#2,2:324\n1878#2,3:326\n1878#2,3:329\n1878#2,3:332\n1878#2,3:335\n*S KotlinDebug\n*F\n+ 1 KotlinScriptWriter.kt\norg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter\n*L\n93#1:320,2\n99#1:322,2\n188#1:324,2\n258#1:326,3\n265#1:329,3\n275#1:332,3\n289#1:335,3\n*E\n"})
public class KotlinScriptWriter {
    @NotNull
    private final Deque<SerializerState> state;
    @NotNull
    private final String indentation;
    private int indentLevel;
    private boolean lineStart;
    private final int argumentWrapThreshold;
    @NotNull
    private final OUT out;
    @NotNull
    private final Regex expressionText;
    @NotNull
    private final Regex booleanLiteral;

    public KotlinScriptWriter(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.state = new LinkedList();
        this.indentation = "    ";
        this.lineStart = true;
        this.argumentWrapThreshold = 50;
        this.out = new OUT(writer);
        this.expressionText = new Regex("[$][{][^}]+[}]");
        this.booleanLiteral = new Regex("true|false");
    }

    protected final int getIndentLevel() {
        return this.indentLevel;
    }

    protected final void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    @NotNull
    protected final KotlinScriptWriter write(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (this.lineStart) {
            int i = 1;
            int n = this.indentLevel;
            if (i <= n) {
                while (true) {
                    this.out.write(this.indentation);
                    if (i == n) break;
                    ++i;
                }
            }
            this.lineStart = false;
        }
        this.out.write(str);
        return this;
    }

    private final KotlinScriptWriter writeString(String value) {
        Object object;
        String escapedValue = DSLSupportKt.escape(value);
        if (Regex.find$default((Regex)this.expressionText, (CharSequence)value, (int)0, (int)2, null) != null) {
            object = this.write('\"' + escapedValue + '\"');
        } else if (!Intrinsics.areEqual((Object)value, (Object)escapedValue)) {
            String escapedRawValue = DSLSupportKt.escapeRaw(value);
            this.tripleQuotedString(escapedRawValue);
            object = Unit.INSTANCE;
        } else {
            object = this.write('\"' + value + '\"');
        }
        return this;
    }

    @NotNull
    protected final KotlinScriptWriter writePair(@NotNull Pair<String, String> pair) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        this.writeString((String)pair.getFirst());
        this.write(" to ");
        String value = (String)pair.getSecond();
        KotlinScriptWriter kotlinScriptWriter = value == null ? this.write("null") : (Intrinsics.areEqual((Object)String.valueOf(StringsKt.toLongOrNull((String)value)), (Object)value) ? this.write(value) : (Intrinsics.areEqual((Object)String.valueOf(StringsKt.toDoubleOrNull((String)value)), (Object)value) ? this.write(value) : (this.booleanLiteral.matches(charSequence = (CharSequence)value) ? this.write(value) : this.writeString(value))));
        return this;
    }

    @NotNull
    protected final KotlinScriptWriter endLine() {
        this.out.write("\n");
        this.lineStart = true;
        return this;
    }

    @NotNull
    protected final KotlinScriptWriter blockComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.write("/*").endLine();
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)StringsKt.prependIndent((String)comment, (String)" * "));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.write(it).endLine();
        }
        this.write(" */").endLine();
        return this;
    }

    @NotNull
    protected final KotlinScriptWriter lineComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)StringsKt.prependIndent((String)comment, (String)"// "));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.write(it).endLine();
        }
        return this;
    }

    protected final <T> void block(@NotNull String name, @Nullable T modelObject, @Nullable Function2<? super T, ? super List<Object>, Unit> args, @Nullable Function1<? super T, Unit> contents) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.block(name, modelObject, "it", args, contents);
    }

    public static /* synthetic */ void block$default(KotlinScriptWriter kotlinScriptWriter, String string, Object object, Function2 function2, Function1 function1, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: block");
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        kotlinScriptWriter.block(string, object, function2, function1);
    }

    protected final <T> void block(@NotNull String name, @Nullable T modelObject, @NotNull String paramName, @Nullable Function2<? super T, ? super List<Object>, Unit> args, @Nullable Function1<? super T, Unit> contents) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        if (modelObject == null) {
            return;
        }
        if (modelObject instanceof Collection && ((Collection)modelObject).isEmpty()) {
            return;
        }
        if (modelObject instanceof Map && ((Map)modelObject).isEmpty()) {
            return;
        }
        if (this.indentLevel == 1) {
            this.endLine();
        }
        if (args != null) {
            List params = new ArrayList();
            args.invoke(modelObject, (Object)params);
            if (params.isEmpty()) {
                if (contents != null) {
                    this.startBlock(name, paramName);
                }
            } else {
                this.function(name, (Function0<Unit>)((Function0)() -> KotlinScriptWriter.block$lambda$2(params, this)));
                if (contents != null) {
                    this.write(" ");
                    this.startBlock(null, paramName);
                }
            }
        } else if (contents != null) {
            this.startBlock(name, paramName);
        }
        if (contents != null) {
            contents.invoke(modelObject);
            this.endBlock();
        }
        this.endLine();
    }

    public static /* synthetic */ void block$default(KotlinScriptWriter kotlinScriptWriter, String string, Object object, String string2, Function2 function2, Function1 function1, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: block");
        }
        if ((n & 8) != 0) {
            function2 = null;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        kotlinScriptWriter.block(string, object, string2, function2, function1);
    }

    protected final void singleQuotedString(@Nullable String text) {
        KotlinScriptWriter kotlinScriptWriter = text == null ? this.write("null") : this.write("\"").write(DSLSupportKt.escape(text)).write("\"");
    }

    private final void tripleQuotedString(String text) {
        KotlinScriptWriter kotlinScriptWriter;
        if (text == null) {
            kotlinScriptWriter = this.write("null");
        } else {
            this.write("\"\"\"");
            this.state.push(SerializerState.RAW_STRING);
            this.incrementIndent();
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)text);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.write(it);
            }
            this.decrementIndent();
            this.state.pop();
            kotlinScriptWriter = this.write("\"\"\"");
        }
    }

    private final KotlinScriptWriter incrementIndent() {
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        return this;
    }

    private final KotlinScriptWriter decrementIndent() {
        int n = this.indentLevel;
        this.indentLevel = n + -1;
        return this;
    }

    private final KotlinScriptWriter startBlock(String name, String paramName) {
        this.write(name == null ? "{" : name + " {");
        if (!Intrinsics.areEqual((Object)paramName, (Object)"it")) {
            this.write(' ' + paramName + " ->");
        }
        this.state.push(SerializerState.BLOCK);
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        this.endLine();
        return this;
    }

    static /* synthetic */ KotlinScriptWriter startBlock$default(KotlinScriptWriter kotlinScriptWriter, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startBlock");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = "it";
        }
        return kotlinScriptWriter.startBlock(string, string2);
    }

    private final KotlinScriptWriter endBlock() {
        int n = this.indentLevel;
        this.indentLevel = n + -1;
        this.write("}");
        this.state.pop();
        return this;
    }

    private final KotlinScriptWriter startFunction(String name) {
        this.write(name + '(');
        this.state.push(SerializerState.FUNCTION);
        return this;
    }

    private final KotlinScriptWriter endFunction() {
        this.write(")");
        this.state.pop();
        return this;
    }

    private final void startField(String name) {
        this.write(name + " = ");
        this.state.push(SerializerState.FIELD);
    }

    private final void endField() {
        this.state.pop();
    }

    private final void startMultiLineString() {
        this.write("\"\"\"");
        this.state.push(SerializerState.RAW_STRING);
        this.incrementIndent();
        this.endLine();
    }

    private final void endMultiLineString() {
        this.write("\"\"\"");
        this.state.pop();
        this.decrementIndent();
    }

    /*
     * WARNING - void declaration
     */
    protected final void arguments(@NotNull List<String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable $this$forEachIndexed$iv = values;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                this.write(", ");
            }
            this.singleQuotedString((String)value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void namedArguments(List<Pair<String, String>> pairs) {
        Iterable $this$forEachIndexed$iv = pairs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pair;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair2 = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                this.write(", ");
            }
            this.write((String)pair.getFirst() + " = ");
            this.singleQuotedString((String)pair.getSecond());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void multiLineArguments(List<String> values) {
        this.incrementIndent();
        this.endLine();
        Iterable $this$forEachIndexed$iv = values;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                this.write(",");
                this.endLine();
            }
            this.singleQuotedString((String)value);
        }
        this.endLine();
        this.decrementIndent();
    }

    /*
     * WARNING - void declaration
     */
    private final void namedMultiLineArguments(List<Pair<String, String>> pairs) {
        this.incrementIndent();
        this.endLine();
        Iterable $this$forEachIndexed$iv = pairs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pair;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair2 = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                this.write(",");
                this.endLine();
            }
            this.write((String)pair.getFirst() + " = ");
            this.singleQuotedString((String)pair.getSecond());
        }
        this.endLine();
        this.decrementIndent();
    }

    protected final void field(@NotNull String fieldName, @NotNull Function0<Unit> contents) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        this.startField(fieldName);
        contents.invoke();
        this.endField();
    }

    protected final void function(@NotNull String functionName, @NotNull Function0<Unit> contents) {
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        this.startFunction(functionName);
        contents.invoke();
        this.endFunction();
    }

    protected final void multiLineString(@NotNull Function0<Unit> contents) {
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        this.startMultiLineString();
        contents.invoke();
        this.endMultiLineString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Unit block$lambda$2(List $params, KotlinScriptWriter this$0) {
        if ($params.size() == 1 || CollectionsKt.joinToString$default((Iterable)$params, null, null, null, (int)0, null, null, (int)63, null).length() < this$0.argumentWrapThreshold) {
            Object e = $params.get(0);
            if (e instanceof Pair) {
                Intrinsics.checkNotNull((Object)$params, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Pair<kotlin.String, kotlin.String>>");
                this$0.namedArguments($params);
                return Unit.INSTANCE;
            } else {
                if (!(e instanceof String)) throw new IllegalArgumentException("The argument type \"" + Reflection.getOrCreateKotlinClass($params.get(0).getClass()) + "\" is unsupported. Must be Pair or String");
                Intrinsics.checkNotNull((Object)$params, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                this$0.arguments($params);
            }
            return Unit.INSTANCE;
        } else {
            Object e = $params.get(0);
            if (e instanceof Pair) {
                Intrinsics.checkNotNull((Object)$params, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Pair<kotlin.String, kotlin.String>>");
                this$0.namedMultiLineArguments($params);
                return Unit.INSTANCE;
            } else {
                if (!(e instanceof String)) throw new IllegalArgumentException("The argument type \"" + Reflection.getOrCreateKotlinClass($params.get(0).getClass()) + "\" is unsupported. Must be Pair or String");
                Intrinsics.checkNotNull((Object)$params, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                this$0.multiLineArguments($params);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter$OUT;", "Ljava/io/Writer;", "out", "<init>", "(Ljava/io/Writer;)V", "position", "", "write", "", "cbuf", "", "off", "", "len", "flush", "close", "polyglot-kotlin"})
    public static final class OUT
    extends Writer {
        @NotNull
        private final Writer out;
        private long position;

        public OUT(@NotNull Writer out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.out = out;
        }

        @Override
        public void write(@NotNull char[] cbuf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
            this.out.write(cbuf, off, len);
            this.position += (long)len;
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
            this.out.close();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/sonatype/maven/polyglot/kotlin/serialization/KotlinScriptWriter$SerializerState;", "", "<init>", "(Ljava/lang/String;I)V", "BLOCK", "FUNCTION", "FIELD", "RAW_STRING", "polyglot-kotlin"})
    private static final class SerializerState
    extends Enum<SerializerState> {
        public static final /* enum */ SerializerState BLOCK = new SerializerState();
        public static final /* enum */ SerializerState FUNCTION = new SerializerState();
        public static final /* enum */ SerializerState FIELD = new SerializerState();
        public static final /* enum */ SerializerState RAW_STRING = new SerializerState();
        private static final /* synthetic */ SerializerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SerializerState[] values() {
            return (SerializerState[])$VALUES.clone();
        }

        public static SerializerState valueOf(String value) {
            return Enum.valueOf(SerializerState.class, value);
        }

        @NotNull
        public static EnumEntries<SerializerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = serializerStateArray = new SerializerState[]{SerializerState.BLOCK, SerializerState.FUNCTION, SerializerState.FIELD, SerializerState.RAW_STRING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

