/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.plugin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.sonatype.maven.polyglot.PolyglotModelManager;
import org.sonatype.maven.polyglot.execute.ExecuteContext;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.execute.ExecuteTask;

@Mojo(name="execute", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExecuteMojo
extends AbstractMojo {
    @Component(role=ExecuteManager.class)
    private ExecuteManager manager;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(required=true, property="taskId")
    private String taskId;
    @Parameter
    private File nativePom;
    @Component(role=PolyglotModelManager.class)
    private PolyglotModelManager modelManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Model model = this.project.getModel();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Executing task '" + this.taskId + "' for model: " + model.getId()));
        }
        assert (this.manager != null);
        List tasks = this.manager.getTasks(model);
        if (tasks.size() == 0 && this.nativePom != null) {
            tasks = this.manager.getTasks(this.modelFromNativePom(log));
        }
        ExecuteContext ctx = new ExecuteContext(){

            public MavenProject getProject() {
                return ExecuteMojo.this.project;
            }

            public MavenSession getSession() {
                return ExecuteMojo.this.session;
            }

            public File getBasedir() {
                return ExecuteMojo.this.project.getBasedir();
            }

            public Log getLog() {
                return ExecuteMojo.this.getLog();
            }
        };
        for (ExecuteTask task : tasks) {
            if (!this.taskId.equals(task.getId())) continue;
            log.debug((CharSequence)("Executing task: " + task.getId()));
            try {
                task.execute(ctx);
                return;
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        throw new MojoFailureException("Unable to find task for id: " + this.taskId);
    }

    protected Model modelFromNativePom(Log log) throws MojoExecutionException, MojoFailureException {
        HashMap<String, FileModelSource> options = new HashMap<String, FileModelSource>();
        options.put("org.apache.maven.model.building.source", new FileModelSource(this.nativePom));
        assert (this.modelManager != null);
        try {
            ModelReader reader = this.modelManager.getReaderFor(options);
            if (reader == null) {
                throw new MojoExecutionException("no model reader found for " + this.nativePom);
            }
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Parsing native pom " + this.nativePom));
            }
            return reader.read(this.nativePom, options);
        }
        catch (IOException e) {
            throw new MojoFailureException("error parsing " + this.nativePom, (Throwable)e);
        }
    }
}

