/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.polyglot;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.maven.polyglot.TeslaModelTranslator;

@Mojo(name="translate-project")
public class TranslateProjectMojo
extends AbstractMojo {
    @Component
    private TeslaModelTranslator translator;
    @Parameter(required=true, property="input")
    private String input;
    @Parameter(required=true, property="output")
    private String output;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File inputFile = new File(this.mavenProject.getBasedir(), this.input);
            File outputFile = new File(this.mavenProject.getBasedir(), this.output);
            this.getLog().info((CharSequence)String.format("Translating %s -> %s", inputFile, outputFile));
            this.translator.translate(inputFile, outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error translating %s -> %s", this.input, this.output), (Exception)e);
        }
    }
}

