/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.xml;

import java.io.FileInputStream;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.maven.polyglot.mapping.MappingSupport;
import org.sonatype.maven.polyglot.xml.xpp3.PolyglotMavenXpp3Reader;

@Singleton
@Named(value="xml41")
public class XMLMapping
extends MappingSupport {
    public XMLMapping() {
        super("xml41");
        this.setPomNames(new String[]{"pom.xml41"});
        this.setAcceptLocationExtensions(new String[]{".xml41", ".xml"});
        this.setAcceptOptionKeys(new String[]{"xml41:4.0.0"});
        this.setPriority(-1.0f);
    }

    public boolean accept(Map<String, ?> options) {
        String location;
        if (options != null && (location = this.getLocation(options)) != null) {
            if (location.endsWith(".xml41")) {
                return true;
            }
            if (location.endsWith(".xml")) {
                return this.canParse(options);
            }
        }
        return false;
    }

    private boolean canParse(Map<String, ?> options) {
        boolean canParse;
        block14: {
            canParse = false;
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(this.getLocation(options));
                    PolyglotMavenXpp3Reader reader = new PolyglotMavenXpp3Reader();
                    reader.read(in);
                    canParse = true;
                }
                catch (Exception exception) {
                    canParse = false;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {
                        canParse = false;
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    canParse = false;
                }
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                canParse = false;
            }
        }
        return canParse;
    }
}

