/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

class ModelRepresenter
extends Representer {
    private static List<String> ORDER_MODEL = new ArrayList<String>(Arrays.asList("modelEncoding", "modelVersion", "parent", "groupId", "artifactId", "version", "packaging", "name", "description", "url", "inceptionYear", "organization", "licenses", "developers", "contributers", "mailingLists", "scm", "issueManagement", "ciManagement", "properties", "prerequisites", "modules", "dependencyManagement", "dependencies", "distributionManagement", "build", "profiles", "reporting"));
    private static List<String> ORDER_DEVELOPER = new ArrayList<String>(Arrays.asList("name", "id", "email"));
    private static List<String> ORDER_CONTRIBUTOR = new ArrayList<String>(Arrays.asList("name", "id", "email"));
    private static List<String> ORDER_DEPENDENCY = new ArrayList<String>(Arrays.asList("groupId", "artifactId", "version", "type", "classifier", "scope"));
    private static List<String> ORDER_PLUGIN = new ArrayList<String>(Arrays.asList("groupId", "artifactId", "version", "inherited", "extensions", "configuration"));

    public ModelRepresenter(DumperOptions options) {
        super(options);
        this.representers.put(Xpp3Dom.class, new RepresentXpp3Dom());
        Represent stringRepresenter = (Represent)this.representers.get(String.class);
        this.representers.put(Boolean.class, stringRepresenter);
        this.multiRepresenters.put(Number.class, stringRepresenter);
        this.multiRepresenters.put(Date.class, stringRepresenter);
        this.multiRepresenters.put(Enum.class, stringRepresenter);
        this.multiRepresenters.put(Calendar.class, stringRepresenter);
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        Object map;
        if (property != null && property.getName().equals("pomFile")) {
            return null;
        }
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof Map && (map = (Map)propertyValue).isEmpty()) {
            return null;
        }
        if (propertyValue instanceof List && (map = (List)propertyValue).isEmpty()) {
            return null;
        }
        if (javaBean instanceof Dependency) {
            if (this.skipBoolean(property, "optional", propertyValue, false)) {
                return null;
            }
            if (this.skipString(property, "type", propertyValue, "jar")) {
                return null;
            }
        }
        if (javaBean instanceof Plugin) {
            if (this.skipBoolean(property, "extensions", propertyValue, false)) {
                return null;
            }
            if (this.skipBoolean(property, "inherited", propertyValue, true)) {
                return null;
            }
        }
        return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
    }

    private boolean skipString(Property property, String name, Object propertyValue, String value) {
        if (name.equals(property.getName())) {
            String v = (String)propertyValue;
            return value.equals(v);
        }
        return false;
    }

    private boolean skipBoolean(Property property, String name, Object propertyValue, boolean value) {
        if (name.equals(property.getName())) {
            Boolean v = (Boolean)propertyValue;
            return v.equals(value);
        }
        return false;
    }

    protected Set<Property> getProperties(Class<? extends Object> type) {
        try {
            if (type.isAssignableFrom(Model.class)) {
                return this.sortTypeWithOrder(type, ORDER_MODEL);
            }
            if (type.isAssignableFrom(Developer.class)) {
                return this.sortTypeWithOrder(type, ORDER_DEVELOPER);
            }
            if (type.isAssignableFrom(Contributor.class)) {
                return this.sortTypeWithOrder(type, ORDER_CONTRIBUTOR);
            }
            if (type.isAssignableFrom(Dependency.class)) {
                return this.sortTypeWithOrder(type, ORDER_DEPENDENCY);
            }
            if (type.isAssignableFrom(Plugin.class)) {
                return this.sortTypeWithOrder(type, ORDER_PLUGIN);
            }
            return super.getProperties(type);
        }
        catch (IntrospectionException e) {
            throw new YAMLException((Throwable)e);
        }
    }

    private Set<Property> sortTypeWithOrder(Class<? extends Object> type, List<String> order) throws IntrospectionException {
        Set standard = super.getProperties(type);
        TreeSet<Property> sorted = new TreeSet<Property>(new ModelPropertyComparator(order));
        sorted.addAll(standard);
        return sorted;
    }

    private class ModelPropertyComparator
    implements Comparator<Property> {
        private List<String> names;

        public ModelPropertyComparator(List<String> names) {
            this.names = names;
        }

        @Override
        public int compare(Property o1, Property o2) {
            for (String name : this.names) {
                int c = this.compareByName(o1, o2, name);
                if (c == 0) continue;
                return c;
            }
            return o1.compareTo(o2);
        }

        private int compareByName(Property o1, Property o2, String name) {
            if (o1.getName().equals(name)) {
                return -1;
            }
            if (o2.getName().equals(name)) {
                return 1;
            }
            return 0;
        }
    }

    private class RepresentXpp3Dom
    implements Represent {
        private static final String ATTRIBUTE_PREFIX = "attr/";

        private RepresentXpp3Dom() {
        }

        public Node representData(Object data) {
            return ModelRepresenter.this.representMapping(Tag.MAP, this.toMap((Xpp3Dom)data), DumperOptions.FlowStyle.AUTO);
        }

        private Map<String, Object> toMap(Xpp3Dom node) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int n = node.getChildCount();
            int i = 0;
            while (i < n) {
                Xpp3Dom child = node.getChild(i);
                String childName = child.getName();
                String singularName = null;
                int childNameLength = childName.length();
                if ("reportPlugins".equals(childName)) {
                    singularName = "plugin";
                } else if (childNameLength > 3 && childName.endsWith("ies")) {
                    singularName = childName.substring(0, childNameLength - 3);
                } else if (childNameLength > 1 && childName.endsWith("s")) {
                    singularName = childName.substring(0, childNameLength - 1);
                }
                Object childValue = child.getValue();
                if (childValue == null) {
                    boolean isList;
                    boolean bl = isList = singularName != null;
                    if (isList) {
                        int j = 0;
                        int grandChildCount = child.getChildCount();
                        while (j < grandChildCount) {
                            String grandChildName = child.getChild(j).getName();
                            isList &= grandChildName.equals(singularName);
                            ++j;
                        }
                    }
                    childValue = isList ? this.toList(child, singularName) : this.toMap(child);
                }
                map.put(childName, childValue);
                ++i;
            }
            String[] stringArray = node.getAttributeNames();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String attrName = stringArray[n3];
                map.put(ATTRIBUTE_PREFIX + attrName, node.getAttribute(attrName));
                ++n3;
            }
            return map;
        }

        private List<Object> toList(Xpp3Dom node, String childName) {
            ArrayList<Object> list = new ArrayList<Object>();
            int n = node.getChildCount();
            int i = 0;
            while (i < n) {
                Xpp3Dom child = node.getChild(i);
                if (!childName.equals(child.getName())) {
                    throw new YAMLException(String.format("child name: '%s' does not match expected name: '%s' at node %s", child.getName(), childName, node));
                }
                Object childValue = child.getValue();
                if (childValue == null) {
                    childValue = this.toMap(child);
                }
                list.add(childValue);
                ++i;
            }
            return list;
        }
    }
}

