/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.yaml.ConstructDependency;
import org.sonatype.maven.polyglot.yaml.ConstructExtension;
import org.sonatype.maven.polyglot.yaml.ConstructParent;
import org.sonatype.maven.polyglot.yaml.ConstructPlugin;
import org.sonatype.maven.polyglot.yaml.ConstructReportPlugin;
import org.sonatype.maven.polyglot.yaml.Coordinate;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public final class ModelConstructor
extends Constructor {
    private static final Tag XPP3DOM_TAG = new Tag("!!" + Xpp3Dom.class.getName());
    private final Map<Class<?>, Construct> pomConstructors = new HashMap();

    public ModelConstructor(LoaderOptions loadingConfig) {
        super(Model.class, loadingConfig);
        this.yamlConstructors.put(XPP3DOM_TAG, new ConstructXpp3Dom());
        this.yamlClassConstructors.put(NodeId.mapping, new MavenObjectConstruct());
        this.pomConstructors.put(Dependency.class, (Construct)new ConstructDependency());
        this.pomConstructors.put(Parent.class, (Construct)new ConstructParent());
        this.pomConstructors.put(Extension.class, (Construct)new ConstructExtension());
        this.pomConstructors.put(Plugin.class, (Construct)new ConstructPlugin());
        this.pomConstructors.put(ReportPlugin.class, (Construct)new ConstructReportPlugin());
        TypeDescription desc = new TypeDescription(Model.class);
        desc.putListPropertyType("licenses", License.class);
        desc.putListPropertyType("mailingLists", MailingList.class);
        desc.putListPropertyType("dependencies", Dependency.class);
        desc.putListPropertyType("modules", String.class);
        desc.putListPropertyType("profiles", Profile.class);
        desc.putListPropertyType("repositories", Repository.class);
        desc.putListPropertyType("pluginRepositories", Repository.class);
        desc.putListPropertyType("developers", Developer.class);
        desc.putListPropertyType("contributors", Contributor.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Dependency.class);
        desc.putListPropertyType("exclusions", Exclusion.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(DependencyManagement.class);
        desc.putListPropertyType("dependencies", Dependency.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Build.class);
        desc.putListPropertyType("extensions", Extension.class);
        desc.putListPropertyType("resources", Resource.class);
        desc.putListPropertyType("testResources", Resource.class);
        desc.putListPropertyType("filters", String.class);
        desc.putListPropertyType("plugins", Plugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(BuildBase.class);
        desc.putListPropertyType("resources", Resource.class);
        desc.putListPropertyType("testResources", Resource.class);
        desc.putListPropertyType("filters", String.class);
        desc.putListPropertyType("plugins", Plugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(PluginManagement.class);
        desc.putListPropertyType("plugins", Plugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Plugin.class);
        desc.putListPropertyType("executions", PluginExecution.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(PluginExecution.class);
        desc.putListPropertyType("goals", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Reporting.class);
        desc.putListPropertyType("plugins", ReportPlugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(ReportPlugin.class);
        desc.putListPropertyType("reportSets", ReportSet.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(ReportSet.class);
        desc.putListPropertyType("reports", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(CiManagement.class);
        desc.putListPropertyType("notifiers", Notifier.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Developer.class);
        desc.putListPropertyType("roles", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Contributor.class);
        desc.putListPropertyType("roles", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(MailingList.class);
        desc.putListPropertyType("otherArchives", String.class);
        this.addTypeDescription(desc);
        this.addTypeDescription(new TypeDescription(DistributionManagement.class));
        this.addTypeDescription(new TypeDescription(Scm.class));
        this.addTypeDescription(new TypeDescription(IssueManagement.class));
        this.addTypeDescription(new TypeDescription(Parent.class));
        this.addTypeDescription(new TypeDescription(Organization.class));
    }

    protected Construct getConstructor(Node node) {
        if (this.pomConstructors.containsKey(node.getType()) && node instanceof ScalarNode) {
            return this.pomConstructors.get(node.getType());
        }
        return super.getConstructor(node);
    }

    private String removeId(MappingNode node) {
        NodeTuple id = null;
        String scalar = null;
        for (NodeTuple tuple : node.getValue()) {
            ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
            String key = keyNode.getValue();
            if (!"id".equals(key)) continue;
            id = tuple;
            ScalarNode valueNode = (ScalarNode)tuple.getValueNode();
            scalar = valueNode.getValue();
        }
        if (id != null) {
            node.getValue().remove(id);
        }
        return scalar;
    }

    private class ConstructXpp3Dom
    implements Construct {
        private static final String ATTRIBUTE_PREFIX = "attr/";

        private ConstructXpp3Dom() {
        }

        private Xpp3Dom toDom(Xpp3Dom parent, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                Object entryValue = entry.getValue();
                Xpp3Dom child = new Xpp3Dom(key);
                if (key.startsWith(ATTRIBUTE_PREFIX)) {
                    this.toAttribute(parent, key.replace(ATTRIBUTE_PREFIX, ""), entryValue);
                    continue;
                }
                if (entryValue instanceof List && !((List)entryValue).isEmpty()) {
                    this.toDom(child, key, (List)entryValue);
                } else if (entryValue instanceof Map) {
                    child = this.toDom(child, (Map)entryValue);
                } else {
                    child.setValue(entryValue.toString());
                }
                parent.addChild(child);
            }
            return parent;
        }

        private void toDom(Xpp3Dom parent, String parentKey, List list) {
            Object firstItem = list.get(0);
            if (firstItem.getClass().isArray()) {
                for (Object item : list) {
                    Object[] pair = (Object[])item;
                    String childKey = "" + pair[0];
                    Xpp3Dom itemNode = new Xpp3Dom(childKey);
                    if (pair[1] != null && pair[1] instanceof Map) {
                        this.toDom(itemNode, (Map)pair[1]);
                    } else {
                        itemNode.setValue("" + pair[1]);
                    }
                    parent.addChild(itemNode);
                }
            } else {
                String childKey;
                if (!parentKey.endsWith("s")) {
                    throw new RuntimeException(String.format("collection key '%s' does not end in 's'. Please resort to the documentation on how to use explicit pairs for specifying child node names", parentKey));
                }
                if ("reportPlugins".equals(parentKey)) {
                    childKey = "plugin";
                } else {
                    childKey = parentKey.substring(0, parentKey.length() - 1);
                    if (childKey.endsWith("ie")) {
                        childKey = String.valueOf(childKey.substring(0, childKey.length() - 2)) + "y";
                    }
                }
                for (Object item : list) {
                    Xpp3Dom itemNode = new Xpp3Dom(childKey);
                    if (item instanceof Map) {
                        this.toDom(itemNode, (Map)item);
                    } else {
                        itemNode.setValue(item.toString());
                    }
                    parent.addChild(itemNode);
                }
            }
        }

        private void toAttribute(Xpp3Dom parent, String key, Object value) {
            if (value instanceof List || value instanceof Map) {
                throw new YAMLException("Attribute's value has to be a plain string. Node: " + parent);
            }
            parent.setAttribute(key, value.toString());
        }

        public Object construct(Node node) {
            Map mapping = ModelConstructor.this.constructMapping((MappingNode)node);
            Xpp3Dom parent = new Xpp3Dom("configuration");
            return this.toDom(parent, mapping);
        }

        public void construct2ndStep(Node node, Object object) {
            throw new YAMLException("Unexpected recursive mapping structure. Node: " + node);
        }
    }

    class MavenObjectConstruct
    extends Constructor.ConstructMapping {
        MavenObjectConstruct() {
            super((Constructor)ModelConstructor.this);
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            Class type = node.getType();
            List<Class> specialCases = Arrays.asList(Dependency.class, Model.class, Plugin.class, ReportPlugin.class);
            List<Class> configurationContainers = Arrays.asList(Plugin.class, PluginExecution.class, ReportPlugin.class, ReportSet.class);
            if (configurationContainers.contains(type)) {
                for (NodeTuple valueNode : node.getValue()) {
                    Node keyNode = valueNode.getKeyNode();
                    Node childValueNode = valueNode.getValueNode();
                    if (!(keyNode instanceof ScalarNode) || !"configuration".equals(((ScalarNode)keyNode).getValue())) continue;
                    childValueNode.setTag(XPP3DOM_TAG);
                }
            }
            if (specialCases.contains(type)) {
                Plugin plugin;
                Coordinate coord;
                String coordinate = ModelConstructor.this.removeId(node);
                if (coordinate == null) {
                    return super.constructJavaBean2ndStep(node, object);
                }
                if (type.equals(Dependency.class)) {
                    Dependency dep = (Dependency)super.constructJavaBean2ndStep(node, object);
                    return ConstructDependency.createDependency(coordinate, dep);
                }
                if (type.equals(Model.class)) {
                    coord = Coordinate.createCoordinate(coordinate);
                    Model model = (Model)super.constructJavaBean2ndStep(node, object);
                    return coord.mergeModel(model);
                }
                if (type.equals(Plugin.class)) {
                    coord = Coordinate.createCoordinate(coordinate);
                    plugin = (Plugin)super.constructJavaBean2ndStep(node, object);
                    return coord.mergePlugin(plugin);
                }
                if (type.equals(ReportPlugin.class)) {
                    coord = Coordinate.createCoordinate(coordinate);
                    plugin = (ReportPlugin)super.constructJavaBean2ndStep(node, object);
                    return coord.mergeReportPlugin((ReportPlugin)plugin);
                }
            }
            return super.constructJavaBean2ndStep(node, object);
        }
    }
}

