/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import io.tesla.proviso.archive.ArchiveHandler;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.DirectorySource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.codehaus.plexus.util.SelectorUtils;

public class Archiver {
    private final List<String> includes;
    private final List<String> excludes;
    private final List<String> executables;
    private final boolean useRoot;
    private final boolean flatten;

    private Archiver(List<String> includes, List<String> excludes, List<String> executables, boolean useRoot, boolean flatten) {
        this.includes = includes;
        this.excludes = excludes;
        this.executables = executables;
        this.useRoot = useRoot;
        this.flatten = flatten;
    }

    public void archive(File archive, List<String> sourceDirectories) throws IOException {
        File[] fileSourceDirectories = new File[sourceDirectories.size()];
        for (int i = 0; i < sourceDirectories.size(); ++i) {
            fileSourceDirectories[i] = new File(sourceDirectories.get(i));
        }
        this.archive(archive, fileSourceDirectories);
    }

    public void archive(File archive, File ... sourceDirectories) throws IOException {
        this.archive(archive, new DirectorySource(sourceDirectories));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive(File archive, Source ... sources) throws IOException {
        ArchiveHandler archiveHandler = ArchiverHelper.getArchiveHandler(archive);
        try (Closer closer = Closer.create();){
            ArchiveOutputStream aos = (ArchiveOutputStream)closer.register((Closeable)archiveHandler.getOutputStream());
            for (Source source : sources) {
                for (Entry entry : source.entries()) {
                    String entryName = entry.getName();
                    boolean exclude = false;
                    if (!this.excludes.isEmpty()) {
                        for (String excludePattern : this.excludes) {
                            if (!SelectorUtils.match((String)excludePattern, (String)entryName)) continue;
                            exclude = true;
                            break;
                        }
                    }
                    if (exclude) continue;
                    boolean include = true;
                    if (!this.includes.isEmpty()) {
                        for (String includePattern : this.includes) {
                            if (SelectorUtils.match((String)includePattern, (String)entryName)) continue;
                            include = false;
                            break;
                        }
                    }
                    if (!include) continue;
                    if (!this.useRoot && source.isDirectory()) {
                        entryName = entryName.substring(entryName.indexOf(47) + 1);
                    }
                    if (this.flatten && source.isDirectory()) {
                        entryName = entryName.substring(entryName.lastIndexOf(47) + 1);
                    }
                    boolean isExecutable = false;
                    for (String executable : this.executables) {
                        if (!SelectorUtils.match((String)executable, (String)entry.getName())) continue;
                        isExecutable = true;
                        break;
                    }
                    ExtendedArchiveEntry archiveEntry = archiveHandler.createEntryFor(entryName, entry, isExecutable);
                    aos.putArchiveEntry((ArchiveEntry)archiveEntry);
                    entry.writeEntry((OutputStream)aos);
                    aos.closeArchiveEntry();
                }
                source.close();
            }
        }
    }

    public static ArchiverBuilder builder() {
        return new ArchiverBuilder();
    }

    public static class ArchiverBuilder {
        private List<String> includes = Lists.newArrayList();
        private List<String> excludes = Lists.newArrayList();
        private List<String> executables = Lists.newArrayList();
        private boolean useRoot = true;
        private boolean flatten = false;

        public ArchiverBuilder includes(String ... includes) {
            return this.includes((Iterable<String>)ImmutableList.copyOf((Object[])includes));
        }

        public ArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public ArchiverBuilder excludes(String ... excludes) {
            return this.excludes((Iterable<String>)ImmutableList.copyOf((Object[])excludes));
        }

        public ArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public ArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public Archiver build() {
            return new Archiver(this.includes, this.excludes, this.executables, this.useRoot, this.flatten);
        }

        public ArchiverBuilder executable(String ... executables) {
            return this.executable((Iterable<String>)ImmutableList.copyOf((Object[])executables));
        }

        public ArchiverBuilder executable(Iterable<String> executables) {
            Iterables.addAll(this.executables, executables);
            return this;
        }

        public ArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }
    }
}

