/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import io.tesla.proviso.archive.ArchiveHandler;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.FileMode;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.codehaus.plexus.util.SelectorUtils;

@Named
@Singleton
public class UnArchiver {
    private final List<String> includes;
    private final List<String> excludes;
    private final boolean useRoot;
    private final boolean flatten;

    public UnArchiver(List<String> includes, List<String> excludes, boolean useRoot, boolean flatten) {
        this.includes = includes;
        this.excludes = excludes;
        this.useRoot = useRoot;
        this.flatten = flatten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unarchive(File archive, File outputDirectory) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        ArchiveHandler archiveHandler = ArchiverHelper.getArchiveHandler(archive);
        try (Closer inputCloser = Closer.create();){
            ArchiveEntry archiveEntry;
            ArchiveInputStream ais = (ArchiveInputStream)inputCloser.register((Closeable)archiveHandler.getInputStream());
            while ((archiveEntry = ais.getNextEntry()) != null) {
                File outputFile;
                String entryName = archiveEntry.getName();
                if (!this.useRoot) {
                    entryName = entryName.substring(entryName.indexOf(47) + 1);
                }
                boolean exclude = false;
                if (!this.excludes.isEmpty()) {
                    for (String excludePattern : this.excludes) {
                        if (!this.isExcluded(excludePattern, entryName)) continue;
                        exclude = true;
                        break;
                    }
                }
                if (exclude) continue;
                boolean include = false;
                if (!this.includes.isEmpty()) {
                    for (String includePattern : this.includes) {
                        if (!this.isIncluded(includePattern, entryName)) continue;
                        include = true;
                        break;
                    }
                } else {
                    include = true;
                }
                if (!include) continue;
                if (this.flatten) {
                    entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
                } else if (archiveEntry.isDirectory()) {
                    this.createDir(new File(outputDirectory, entryName));
                    continue;
                }
                if ((outputFile = new File(outputDirectory, entryName)).getAbsolutePath().equals(outputDirectory.getAbsolutePath())) continue;
                if (!outputFile.getParentFile().exists()) {
                    this.createDir(outputFile.getParentFile());
                }
                try (Closer outputCloser = Closer.create();){
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                    ByteStreams.copy((InputStream)ais, (OutputStream)outputStream);
                }
                int mode = 0;
                if (archiveEntry instanceof ZipArchiveEntry) {
                    mode = ((ZipArchiveEntry)archiveEntry).getUnixMode();
                } else if (archiveEntry instanceof TarArchiveEntry) {
                    mode = ((TarArchiveEntry)archiveEntry).getMode();
                }
                if (!FileMode.EXECUTABLE_FILE.equals(mode)) continue;
                outputFile.setExecutable(true);
            }
        }
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private boolean isExcluded(String excludePattern, String entry) {
        return SelectorUtils.match((String)excludePattern, (String)entry);
    }

    private boolean isIncluded(String includePattern, String entry) {
        return SelectorUtils.match((String)includePattern, (String)entry);
    }

    public static UnArchiverBuilder builder() {
        return new UnArchiverBuilder();
    }

    public static class UnArchiverBuilder {
        private List<String> includes = new ArrayList<String>();
        private List<String> excludes = new ArrayList<String>();
        private boolean useRoot = true;
        private boolean flatten = false;

        public UnArchiverBuilder includes(String ... includes) {
            return this.includes((Iterable<String>)ImmutableList.copyOf((Object[])includes));
        }

        public UnArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public UnArchiverBuilder excludes(String ... excludes) {
            return this.excludes((Iterable<String>)ImmutableList.copyOf((Object[])excludes));
        }

        public UnArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public UnArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public UnArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public UnArchiver build() {
            return new UnArchiver(this.includes, this.excludes, this.useRoot, this.flatten);
        }
    }
}

