/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import io.tesla.proviso.archive.Entry;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileEntry
implements Entry {
    private final String name;
    private final File file;

    public FileEntry(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEntry(OutputStream outputStream) throws IOException {
        if (this.file.isDirectory()) {
            return;
        }
        try (Closer closer = Closer.create();){
            InputStream entryInputStream = (InputStream)closer.register((Closeable)this.getInputStream());
            ByteStreams.copy((InputStream)entryInputStream, (OutputStream)outputStream);
        }
    }

    @Override
    public int getFileMode() {
        return -1;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }
}

