/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Selector;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.UnarchivingEntryProcessor;
import io.tesla.proviso.archive.perms.FileMode;
import io.tesla.proviso.archive.perms.PosixModes;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class UnArchiver {
    private final Selector selector;
    private final boolean useRoot;
    private final boolean flatten;
    private final boolean dereferenceHardlinks;
    private final UnArchiverBuilder builder;

    public UnArchiver(UnArchiverBuilder builder) {
        this.builder = builder;
        this.useRoot = builder.useRoot;
        this.flatten = builder.flatten;
        this.dereferenceHardlinks = builder.dereferenceHardlinks;
        this.selector = new Selector(builder.includes, builder.excludes);
    }

    public void unarchive(File archive, File outputDirectory) throws IOException {
        this.unarchive(archive, outputDirectory, new NoopEntryProcessor());
    }

    public void unarchive(File archive, File outputDirectory, UnarchivingEntryProcessor entryProcessor) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        Source source = ArchiverHelper.getArchiveHandler(archive, this.builder).getArchiveSource();
        for (ExtendedArchiveEntry archiveEntry : source.entries()) {
            Serializable hardLinkSource;
            String entryName = this.adjustPath(archiveEntry.getName(), entryProcessor);
            if (!this.selector.include(entryName)) continue;
            if (archiveEntry.isDirectory()) {
                this.createDir(new File(outputDirectory, entryName));
                continue;
            }
            File outputFile = new File(outputDirectory, entryName);
            if (outputFile.getAbsolutePath().equals(outputDirectory.getAbsolutePath())) continue;
            if (!outputFile.getParentFile().exists()) {
                this.createDir(outputFile.getParentFile());
            }
            if (archiveEntry.isHardLink()) {
                hardLinkSource = new File(outputDirectory, this.adjustPath(archiveEntry.getHardLinkPath(), entryProcessor));
                if (this.dereferenceHardlinks) {
                    Files.copy(((File)hardLinkSource).toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.deleteIfExists(outputFile.toPath());
                    Files.createLink(outputFile.toPath(), ((File)hardLinkSource).toPath());
                }
            } else {
                hardLinkSource = null;
                Object var10_12 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                    entryProcessor.processStream(archiveEntry.getName(), archiveEntry.getInputStream(), outputStream);
                }
                catch (Throwable throwable) {
                    if (hardLinkSource == null) {
                        hardLinkSource = throwable;
                    } else if (hardLinkSource != throwable) {
                        ((Throwable)hardLinkSource).addSuppressed(throwable);
                    }
                    throw hardLinkSource;
                }
            }
            int mode = archiveEntry.getFileMode();
            if (mode > 0) {
                this.setFilePermissions(outputFile, FileMode.toPermissionsSet(mode));
                continue;
            }
            if (archiveEntry.isDirectory()) {
                this.setFilePermissions(outputFile, PosixModes.intModeToPosix(493));
                continue;
            }
            this.setFilePermissions(outputFile, PosixModes.intModeToPosix(420));
        }
        source.close();
    }

    private String adjustPath(String entryName, UnarchivingEntryProcessor entryProcessor) {
        if (!this.useRoot) {
            entryName = entryName.substring(entryName.indexOf(47) + 1);
        }
        entryName = entryProcessor.processName(entryName);
        if (this.flatten) {
            entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
        }
        return entryName;
    }

    private void setFilePermissions(File file, Set<PosixFilePermission> perms) throws IOException {
        try {
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static UnArchiverBuilder builder() {
        return new UnArchiverBuilder();
    }

    class NoopEntryProcessor
    implements UnarchivingEntryProcessor {
        NoopEntryProcessor() {
        }

        @Override
        public String processName(String entryName) {
            return entryName;
        }

        @Override
        public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public static class UnArchiverBuilder {
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();
        boolean useRoot = true;
        boolean flatten = false;
        boolean posixLongFileMode;
        boolean dereferenceHardlinks = false;

        public UnArchiverBuilder includes(String ... includes) {
            ArrayList i = Lists.newArrayList();
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String include = stringArray[n2];
                if (include != null) {
                    i.add(include);
                }
                ++n2;
            }
            return this.includes((Iterable<String>)ImmutableList.copyOf((Collection)i));
        }

        public UnArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public UnArchiverBuilder excludes(String ... excludes) {
            ArrayList i = Lists.newArrayList();
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                if (exclude != null) {
                    i.add(exclude);
                }
                ++n2;
            }
            return this.excludes((Iterable<String>)ImmutableList.copyOf((Collection)i));
        }

        public UnArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public UnArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public UnArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public UnArchiverBuilder posixLongFileMode(boolean posixLongFileMode) {
            this.posixLongFileMode = posixLongFileMode;
            return this;
        }

        public UnArchiverBuilder dereferenceHardlinks(boolean dereferenceHardlinks) {
            this.dereferenceHardlinks = dereferenceHardlinks;
            return this;
        }

        public UnArchiver build() {
            return new UnArchiver(this);
        }
    }
}

