/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.UnarchivingEntryProcessor;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.SelectorUtils;

@Named
@Singleton
public class UnArchiver {
    private final List<String> includes;
    private final List<String> excludes;
    private final boolean useRoot;
    private final boolean flatten;

    public UnArchiver(List<String> includes, List<String> excludes, boolean useRoot, boolean flatten) {
        this.includes = includes;
        this.excludes = excludes;
        this.useRoot = useRoot;
        this.flatten = flatten;
    }

    public void unarchive(File archive, File outputDirectory) throws IOException {
        this.unarchive(archive, outputDirectory, new NoopEntryProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unarchive(File archive, File outputDirectory, UnarchivingEntryProcessor entryProcessor) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        Source source = ArchiverHelper.getArchiveHandler(archive).getArchiveSource();
        for (Entry archiveEntry : source.entries()) {
            File outputFile;
            String entryName = archiveEntry.getName();
            if (!this.useRoot) {
                entryName = entryName.substring(entryName.indexOf(47) + 1);
            }
            boolean exclude = false;
            if (!this.excludes.isEmpty()) {
                for (String excludePattern : this.excludes) {
                    if (!this.isExcluded(excludePattern, entryName)) continue;
                    exclude = true;
                    break;
                }
            }
            if (exclude) continue;
            boolean include = false;
            if (!this.includes.isEmpty()) {
                for (String includePattern : this.includes) {
                    if (!this.isIncluded(includePattern, entryName)) continue;
                    include = true;
                    break;
                }
            } else {
                include = true;
            }
            if (!include) continue;
            entryName = entryProcessor.processName(entryName);
            if (this.flatten) {
                entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
            } else if (archiveEntry.isDirectory()) {
                this.createDir(new File(outputDirectory, entryName));
                continue;
            }
            if ((outputFile = new File(outputDirectory, entryName)).getAbsolutePath().equals(outputDirectory.getAbsolutePath())) continue;
            if (!outputFile.getParentFile().exists()) {
                this.createDir(outputFile.getParentFile());
            }
            try (Closer closer = Closer.create();){
                OutputStream outputStream = (OutputStream)closer.register((Closeable)new BufferedOutputStream(new FileOutputStream(outputFile)));
                entryProcessor.processStream(archiveEntry.getInputStream(), outputStream);
            }
            int mode = archiveEntry.getFileMode();
            if ((mode & 0x40) == 0) continue;
            outputFile.setExecutable(true);
        }
        source.close();
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private boolean isExcluded(String excludePattern, String entry) {
        return SelectorUtils.match((String)excludePattern, (String)entry);
    }

    private boolean isIncluded(String includePattern, String entry) {
        return SelectorUtils.match((String)includePattern, (String)entry);
    }

    public static UnArchiverBuilder builder() {
        return new UnArchiverBuilder();
    }

    public static class UnArchiverBuilder {
        private List<String> includes = new ArrayList<String>();
        private List<String> excludes = new ArrayList<String>();
        private boolean useRoot = true;
        private boolean flatten = false;

        public UnArchiverBuilder includes(String ... includes) {
            ArrayList i = Lists.newArrayList();
            for (String include : includes) {
                if (include == null) continue;
                i.add(include);
            }
            return this.includes((Iterable<String>)ImmutableList.copyOf((Collection)i));
        }

        public UnArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public UnArchiverBuilder excludes(String ... excludes) {
            ArrayList i = Lists.newArrayList();
            for (String exclude : excludes) {
                if (exclude == null) continue;
                i.add(exclude);
            }
            return this.excludes((Iterable<String>)ImmutableList.copyOf((Collection)i));
        }

        public UnArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public UnArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public UnArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public UnArchiver build() {
            return new UnArchiver(this.includes, this.excludes, this.useRoot, this.flatten);
        }
    }

    class NoopEntryProcessor
    implements UnarchivingEntryProcessor {
        NoopEntryProcessor() {
        }

        @Override
        public String processName(String name) {
            return name;
        }

        @Override
        public void processStream(InputStream inputStream, OutputStream outputStream) throws IOException {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }
}

