/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.tar;

import io.tesla.proviso.archive.ArchiveHandler;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.FileMode;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.tar.ExtendedTarArchiveEntry;
import io.tesla.proviso.archive.tar.TarGzArchiveSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TarGzArchiveHandler
implements ArchiveHandler {
    private final File archive;

    public TarGzArchiveHandler(File archive) {
        this.archive = archive;
    }

    @Override
    public ArchiveInputStream getInputStream() throws IOException {
        return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(this.archive)));
    }

    @Override
    public ArchiveOutputStream getOutputStream() throws IOException {
        TarArchiveOutputStream aos = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(this.archive)));
        return aos;
    }

    @Override
    public ExtendedArchiveEntry createEntryFor(String entryName, Entry archiveEntry, boolean isExecutable) {
        ExtendedTarArchiveEntry entry = new ExtendedTarArchiveEntry(entryName);
        entry.setSize(archiveEntry.getSize());
        if (isExecutable) {
            entry.setMode(FileMode.EXECUTABLE_FILE.getBits());
        }
        if (archiveEntry.getFileMode() != -1) {
            entry.setMode(archiveEntry.getFileMode());
        }
        return entry;
    }

    @Override
    public Source getArchiveSource() {
        return new TarGzArchiveSource(this.archive);
    }
}

