/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.zip;

import com.google.common.io.ByteStreams;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.Source;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipArchiveSource
implements Source {
    private ZipFile zipFile;
    private Enumeration<ZipArchiveEntry> entries;

    public ZipArchiveSource(File archive) {
        try {
            this.zipFile = new ZipFile(archive);
            this.entries = this.zipFile.getEntries();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot determine the type of archive %s.", archive), e);
        }
    }

    @Override
    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return new ArchiveEntryIterator();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class ArchiveEntryIterator
    implements Iterator<Entry> {
        ArchiveEntryIterator() {
        }

        @Override
        public Entry next() {
            return new EntrySourceArchiveEntry((ZipArchiveEntry)ZipArchiveSource.this.entries.nextElement());
        }

        @Override
        public boolean hasNext() {
            return ZipArchiveSource.this.entries.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }

    class EntrySourceArchiveEntry
    implements Entry {
        final ZipArchiveEntry archiveEntry;

        public EntrySourceArchiveEntry(ZipArchiveEntry archiveEntry) {
            this.archiveEntry = archiveEntry;
        }

        @Override
        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return ZipArchiveSource.this.zipFile.getInputStream(this.archiveEntry);
        }

        @Override
        public long getSize() {
            return this.archiveEntry.getSize();
        }

        @Override
        public void writeEntry(OutputStream outputStream) throws IOException {
            ByteStreams.copy((InputStream)this.getInputStream(), (OutputStream)outputStream);
        }

        @Override
        public int getFileMode() {
            return this.archiveEntry.getUnixMode();
        }

        @Override
        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }
    }
}

