/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public abstract class FileMode {
    public static final int TYPE_MASK = 61440;
    public static final int TYPE_TREE = 16384;
    public static final int TYPE_SYMLINK = 40960;
    public static final int TYPE_FILE = 32768;
    public static final int TYPE_GITLINK = 57344;
    public static final int TYPE_MISSING = 0;
    public static final FileMode TREE = new FileMode(16384){

        @Override
        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 16384;
        }
    };
    public static final FileMode SYMLINK = new FileMode(40960){

        @Override
        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 40960;
        }
    };
    public static final FileMode REGULAR_FILE = new FileMode(33188){

        @Override
        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 32768 && (modeBits & 0x49) == 0;
        }
    };
    public static final FileMode EXECUTABLE_FILE = new FileMode(33261){

        @Override
        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 32768 && (modeBits & 0x49) != 0;
        }
    };
    public static final FileMode GITLINK = new FileMode(57344){

        @Override
        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 57344;
        }
    };
    public static final FileMode MISSING = new FileMode(0){

        @Override
        public boolean equals(int modeBits) {
            return modeBits == 0;
        }
    };
    private final byte[] octalBytes;
    private final int modeBits;

    public static final FileMode fromBits(final int bits) {
        switch (bits & 0xF000) {
            case 0: {
                if (bits != 0) break;
                return MISSING;
            }
            case 16384: {
                return TREE;
            }
            case 32768: {
                if ((bits & 0x49) != 0) {
                    return EXECUTABLE_FILE;
                }
                return REGULAR_FILE;
            }
            case 40960: {
                return SYMLINK;
            }
            case 57344: {
                return GITLINK;
            }
        }
        return new FileMode(bits){

            @Override
            public boolean equals(int a) {
                return bits == a;
            }
        };
    }

    private FileMode(int mode) {
        this.modeBits = mode;
        if (mode != 0) {
            byte[] tmp = new byte[10];
            int p = tmp.length;
            while (mode != 0) {
                tmp[--p] = (byte)(48 + (mode & 7));
                mode >>= 3;
            }
            this.octalBytes = new byte[tmp.length - p];
            for (int k = 0; k < this.octalBytes.length; ++k) {
                this.octalBytes[k] = tmp[p + k];
            }
        } else {
            this.octalBytes = new byte[]{48};
        }
    }

    public abstract boolean equals(int var1);

    public void copyTo(OutputStream os) throws IOException {
        os.write(this.octalBytes);
    }

    public void copyTo(byte[] buf, int ptr) {
        System.arraycopy(this.octalBytes, 0, buf, ptr, this.octalBytes.length);
    }

    public int copyToLength() {
        return this.octalBytes.length;
    }

    public String toString() {
        return Integer.toOctalString(this.modeBits);
    }

    public int getBits() {
        return this.modeBits;
    }

    public static int makeExecutable(int fileMode) {
        return fileMode | 0x49;
    }

    public static int getFileMode(File file) {
        Set<PosixFilePermission> posixPermissions;
        try {
            posixPermissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
        }
        catch (IOException e) {
            return -1;
        }
        int result = 0;
        if (posixPermissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            result |= 0x100;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result |= 0x80;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result |= 0x40;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            result |= 0x20;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result |= 0x10;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result |= 8;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result |= 4;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result |= 2;
        }
        if (posixPermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result |= 1;
        }
        return result;
    }

    public static Set<PosixFilePermission> toPermissionsSet(int mode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if (FileMode.isSet(mode, 256)) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if (FileMode.isSet(mode, 128)) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if (FileMode.isSet(mode, 64)) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (FileMode.isSet(mode, 32)) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if (FileMode.isSet(mode, 16)) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if (FileMode.isSet(mode, 8)) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (FileMode.isSet(mode, 4)) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if (FileMode.isSet(mode, 2)) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (FileMode.isSet(mode, 1)) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static String toUnix(int mode) {
        char[] unix = new char[10];
        for (int i = 0; i < 10; ++i) {
            unix[i] = 45;
        }
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if (FileMode.isSet(mode, 256)) {
            unix[1] = 114;
        }
        if (FileMode.isSet(mode, 128)) {
            result.add(PosixFilePermission.OWNER_WRITE);
            unix[2] = 119;
        }
        if (FileMode.isSet(mode, 64)) {
            unix[3] = 120;
        }
        if (FileMode.isSet(mode, 32)) {
            unix[4] = 114;
        }
        if (FileMode.isSet(mode, 16)) {
            unix[5] = 119;
        }
        if (FileMode.isSet(mode, 8)) {
            unix[6] = 120;
        }
        if (FileMode.isSet(mode, 4)) {
            unix[7] = 114;
        }
        if (FileMode.isSet(mode, 2)) {
            unix[8] = 119;
        }
        if (FileMode.isSet(mode, 1)) {
            unix[9] = 120;
        }
        return new String(unix);
    }

    private static boolean isSet(int mode, int bit) {
        return (mode & bit) == bit;
    }
}

