/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.zip;

import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.perms.FileMode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipArchiveSource
implements Source {
    private final ZipFile zipFile;
    private final Enumeration<ZipArchiveEntry> entries;

    public ZipArchiveSource(File archive) {
        try {
            this.zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(archive)).setUseUnicodeExtraFields(false).get();
            this.entries = this.zipFile.getEntries();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot determine the type of archive %s.", archive), e);
        }
    }

    @Override
    public Iterable<ExtendedArchiveEntry> entries() {
        return () -> new ArchiveEntryIterator();
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class ArchiveEntryIterator
    implements Iterator<ExtendedArchiveEntry> {
        ArchiveEntryIterator() {
        }

        @Override
        public ExtendedArchiveEntry next() {
            return new EntrySourceArchiveEntry(ZipArchiveSource.this.entries.nextElement());
        }

        @Override
        public boolean hasNext() {
            return ZipArchiveSource.this.entries.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }

    class EntrySourceArchiveEntry
    implements ExtendedArchiveEntry {
        final ZipArchiveEntry archiveEntry;

        public EntrySourceArchiveEntry(ZipArchiveEntry archiveEntry) {
            this.archiveEntry = archiveEntry;
        }

        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return ZipArchiveSource.this.zipFile.getInputStream(this.archiveEntry);
        }

        @Override
        public boolean isSymbolicLink() {
            return this.archiveEntry.isUnixSymlink();
        }

        /*
         * Loose catch block
         */
        @Override
        public String getSymbolicLinkPath() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try {
                    String string;
                    ByteArrayOutputStream os;
                    InputStream is;
                    block18: {
                        block17: {
                            is = this.getInputStream();
                            os = new ByteArrayOutputStream();
                            is.transferTo(os);
                            string = os.toString();
                            if (os == null) break block17;
                            os.close();
                        }
                        if (is == null) break block18;
                        is.close();
                    }
                    return string;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (os != null) {
                                    os.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isHardLink() {
            return false;
        }

        @Override
        public String getHardLinkPath() {
            return null;
        }

        public long getSize() {
            return this.archiveEntry.getSize();
        }

        @Override
        public void writeEntry(OutputStream outputStream) throws IOException {
            this.getInputStream().transferTo(outputStream);
        }

        @Override
        public void setFileMode(int mode) {
        }

        @Override
        public int getFileMode() {
            return this.archiveEntry.getUnixMode();
        }

        @Override
        public void setSize(long size) {
        }

        @Override
        public void setTime(long time) {
        }

        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }

        public Date getLastModifiedDate() {
            return null;
        }

        @Override
        public boolean isExecutable() {
            return FileMode.EXECUTABLE_FILE.equals(this.getFileMode());
        }

        @Override
        public long getTime() {
            return this.archiveEntry.getTime();
        }
    }
}

