/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive;

import ca.vanzyl.provisio.archive.ArchiveHandler;
import ca.vanzyl.provisio.archive.ArchiverHelper;
import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Selector;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.source.DirectoryEntry;
import ca.vanzyl.provisio.archive.source.DirectorySource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.codehaus.plexus.util.SelectorUtils;

public class Archiver {
    public static final long DOS_EPOCH_IN_JAVA_TIME = 315561600000L;
    public static final long MINIMUM_TIMESTAMP_INCREMENT = 2000L;
    private final Map<String, ExtendedArchiveEntry> entries = new TreeMap<String, ExtendedArchiveEntry>();
    private final List<String> executables;
    private final boolean useRoot;
    private final boolean flatten;
    private final boolean normalize;
    private final String prefix;
    private final Selector selector;
    private final ArchiverBuilder builder;

    private Archiver(ArchiverBuilder builder) {
        this.builder = builder;
        this.executables = builder.executables;
        this.useRoot = builder.useRoot;
        this.flatten = builder.flatten;
        this.normalize = builder.normalize;
        this.prefix = builder.prefix;
        this.selector = new Selector(builder.includes, builder.excludes);
    }

    public void archive(File archive, List<String> sourceDirectories) throws IOException {
        File[] fileSourceDirectories = new File[sourceDirectories.size()];
        int i = 0;
        while (i < sourceDirectories.size()) {
            fileSourceDirectories[i] = new File(sourceDirectories.get(i));
            ++i;
        }
        this.archive(archive, fileSourceDirectories);
    }

    public void archive(File archive, File ... sourceDirectories) throws IOException {
        this.archive(archive, new DirectorySource(sourceDirectories));
    }

    public void archive(File archive, Source ... sources) throws IOException {
        ArchiveHandler archiveHandler = ArchiverHelper.getArchiveHandler(archive, this.builder);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ArchiveOutputStream aos = archiveHandler.getOutputStream();){
            HashMap<Object, Boolean> paths = new HashMap<Object, Boolean>();
            Source[] sourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Source source = sourceArray[n2];
                for (ExtendedArchiveEntry entry : source.entries()) {
                    Object entryName = entry.getName();
                    if (!this.selector.include((String)entryName)) continue;
                    if (source.isDirectory()) {
                        if (!this.useRoot) {
                            entryName = ((String)entryName).substring(((String)entryName).indexOf(47) + 1);
                        }
                        if (this.flatten) {
                            if (entry.isDirectory()) continue;
                            entryName = ((String)entryName).substring(((String)entryName).lastIndexOf(47) + 1);
                        }
                    }
                    if (this.prefix != null) {
                        entryName = this.prefix + (String)entryName;
                    }
                    boolean isExecutable = false;
                    for (String executable : this.executables) {
                        if (!SelectorUtils.match((String)executable, (String)entry.getName())) continue;
                        isExecutable = true;
                        break;
                    }
                    if (entry.isDirectory() && !((String)entryName).endsWith("/")) {
                        entryName = (String)entryName + "/";
                    }
                    for (String directoryName : this.getParentDirectoryNames((String)entryName)) {
                        if (paths.containsKey(directoryName)) continue;
                        paths.put(directoryName, Boolean.FALSE);
                        ExtendedArchiveEntry directoryEntry = archiveHandler.createEntryFor(directoryName, new DirectoryEntry(directoryName), false);
                        this.addEntry(directoryName, directoryEntry, aos);
                    }
                    if (!paths.containsKey(entryName)) {
                        paths.put(entryName, Boolean.TRUE);
                        ExtendedArchiveEntry archiveEntry = archiveHandler.createEntryFor((String)entryName, entry, isExecutable);
                        this.addEntry((String)entryName, archiveEntry, aos);
                        continue;
                    }
                    if (!Boolean.TRUE.equals(paths.get(entryName))) continue;
                    throw new IllegalArgumentException("Duplicate archive entry " + (String)entryName);
                }
                source.close();
                ++n2;
            }
            if (!this.entries.isEmpty()) {
                for (Map.Entry<String, ExtendedArchiveEntry> entry : this.entries.entrySet()) {
                    ExtendedArchiveEntry archiveEntry = entry.getValue();
                    this.writeEntry(archiveEntry, aos);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Iterable<String> getParentDirectoryNames(String entryName) {
        ArrayList<String> directoryNames = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(entryName, "/");
        if (st.hasMoreTokens()) {
            StringBuilder directoryName = new StringBuilder(st.nextToken());
            while (st.hasMoreTokens()) {
                directoryName.append('/');
                directoryNames.add(directoryName.toString());
                directoryName.append(st.nextToken());
            }
        }
        return directoryNames;
    }

    private long normalizedTimestamp(String name) {
        if (name.endsWith(".class")) {
            return 315561602000L;
        }
        return 315561600000L;
    }

    private long newEntryTimeMillis(String filename) {
        return this.normalize ? this.normalizedTimestamp(filename) : System.currentTimeMillis();
    }

    private void addEntry(String entryName, ExtendedArchiveEntry entry, ArchiveOutputStream aos) throws IOException {
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        } else if (entryName.startsWith("./")) {
            entryName = entryName.substring(2);
        }
        if (this.normalize) {
            entry.setTime(this.newEntryTimeMillis(entryName));
            this.entries.put(entryName, entry);
        } else {
            this.writeEntry(entry, aos);
        }
    }

    private void writeEntry(ExtendedArchiveEntry entry, ArchiveOutputStream aos) throws IOException {
        aos.putArchiveEntry((ArchiveEntry)entry);
        if (!entry.isHardLink() && !entry.isDirectory()) {
            entry.writeEntry((OutputStream)aos);
        }
        aos.closeArchiveEntry();
    }

    public static ArchiverBuilder builder() {
        return new ArchiverBuilder();
    }

    public static class ArchiverBuilder {
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();
        List<String> executables = new ArrayList<String>();
        boolean useRoot = true;
        boolean flatten = false;
        boolean normalize = false;
        String prefix;
        boolean posixLongFileMode;
        List<String> hardLinkIncludes = new ArrayList<String>();
        List<String> hardLinkExcludes = new ArrayList<String>();

        public ArchiverBuilder includes(String ... includes) {
            return this.includes(List.of(includes));
        }

        public ArchiverBuilder includes(Iterable<String> includes) {
            includes.forEach(this.includes::add);
            return this;
        }

        public ArchiverBuilder excludes(String ... excludes) {
            return this.excludes(List.of(excludes));
        }

        public ArchiverBuilder excludes(Iterable<String> excludes) {
            excludes.forEach(this.excludes::add);
            return this;
        }

        public ArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public ArchiverBuilder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public ArchiverBuilder executable(String ... executables) {
            return this.executable(List.of(executables));
        }

        public ArchiverBuilder executable(Iterable<String> executables) {
            executables.forEach(this.executables::add);
            return this;
        }

        public ArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public ArchiverBuilder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ArchiverBuilder posixLongFileMode(boolean posixLongFileMode) {
            this.posixLongFileMode = posixLongFileMode;
            return this;
        }

        public ArchiverBuilder hardLinkIncludes(String ... hardLinkIncludes) {
            return this.hardLinkIncludes(List.of(hardLinkIncludes));
        }

        public ArchiverBuilder hardLinkIncludes(Iterable<String> hardLinkIncludes) {
            hardLinkIncludes.forEach(this.hardLinkIncludes::add);
            return this;
        }

        public ArchiverBuilder hardLinkExcludes(String ... hardLinkExcludes) {
            return this.hardLinkExcludes(List.of(hardLinkExcludes));
        }

        public ArchiverBuilder hardLinkExcludes(Iterable<String> hardLinkExcludes) {
            hardLinkExcludes.forEach(this.hardLinkExcludes::add);
            return this;
        }

        public Archiver build() {
            return new Archiver(this);
        }
    }
}

