/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive;

import ca.vanzyl.provisio.archive.ArchiverHelper;
import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Selector;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.UnarchivingEnhancedEntryProcessor;
import ca.vanzyl.provisio.archive.UnarchivingEntryProcessor;
import ca.vanzyl.provisio.archive.perms.FileMode;
import ca.vanzyl.provisio.archive.perms.PosixModes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.codehaus.plexus.util.io.CachingOutputStream;

public class UnArchiver {
    private final Selector selector;
    private final boolean useRoot;
    private final boolean flatten;
    private final boolean dereferenceHardlinks;
    private final UnArchiverBuilder builder;

    public UnArchiver(UnArchiverBuilder builder) {
        this.builder = builder;
        this.useRoot = builder.useRoot;
        this.flatten = builder.flatten;
        this.dereferenceHardlinks = builder.dereferenceHardlinks;
        this.selector = new Selector(builder.includes, builder.excludes);
    }

    public void unarchive(File archive, File outputDirectory) throws IOException {
        Objects.requireNonNull(archive);
        Objects.requireNonNull(outputDirectory);
        this.unarchive(archive.toPath(), outputDirectory.toPath(), new NoopEntryProcessor());
    }

    @Deprecated
    public void unarchive(File archive, File outputDirectory, final UnarchivingEntryProcessor entryProcessor) throws IOException {
        Objects.requireNonNull(archive);
        Objects.requireNonNull(outputDirectory);
        Objects.requireNonNull(entryProcessor);
        this.unarchive(archive.toPath(), outputDirectory.toPath(), new UnarchivingEnhancedEntryProcessor(){

            @Override
            public String targetName(String name) {
                return entryProcessor.processName(name);
            }

            @Override
            public String sourceName(String name) {
                return entryProcessor.processName(name);
            }

            @Override
            public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
                entryProcessor.processStream(entryName, inputStream, outputStream);
            }
        });
    }

    public void unarchive(Path archive, Path outputDirectory, UnarchivingEnhancedEntryProcessor entryProcessor) throws IOException {
        Objects.requireNonNull(archive);
        Objects.requireNonNull(outputDirectory);
        Objects.requireNonNull(entryProcessor);
        archive = archive.toAbsolutePath();
        outputDirectory = outputDirectory.toAbsolutePath();
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        Source source = ArchiverHelper.getArchiveHandler(archive.toFile(), this.builder).getArchiveSource();
        for (ExtendedArchiveEntry archiveEntry : source.entries()) {
            String entryName = this.adjustPath(true, archiveEntry.getName(), entryProcessor);
            if (!this.selector.include(entryName)) continue;
            Path outputFile = outputDirectory.resolve(entryName).toAbsolutePath();
            if (!outputFile.startsWith(outputDirectory)) {
                throw new IOException("Archive escape attempt detected in " + String.valueOf(archive));
            }
            if (archiveEntry.isDirectory()) {
                Files.createDirectories(outputFile, new FileAttribute[0]);
                entryProcessor.processed(entryName, outputFile);
                continue;
            }
            if (outputFile.equals(outputDirectory)) {
                entryProcessor.processed(entryName, outputFile);
                continue;
            }
            if (!Files.isDirectory(outputFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            if (archiveEntry.isHardLink()) {
                Path hardLinkSource = outputDirectory.resolve(this.adjustPath(false, archiveEntry.getHardLinkPath(), entryProcessor)).toAbsolutePath();
                if (this.dereferenceHardlinks) {
                    Files.copy(hardLinkSource, outputFile, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.deleteIfExists(outputFile);
                    Files.createLink(outputFile, hardLinkSource);
                }
                this.setFilePermission(archiveEntry, outputFile);
                entryProcessor.processed(entryName, outputFile);
                continue;
            }
            if (archiveEntry.isSymbolicLink()) {
                Path link = outputDirectory.resolve(entryName);
                Path target = outputDirectory.relativize(outputDirectory.resolve(archiveEntry.getSymbolicLinkPath()));
                Files.createDirectories(link.getParent(), new FileAttribute[0]);
                Files.createSymbolicLink(link, target, new FileAttribute[0]);
                entryProcessor.processed(entryName, link.toAbsolutePath());
                continue;
            }
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (CachingOutputStream outputStream = new CachingOutputStream(outputFile);){
                    entryProcessor.processStream(archiveEntry.getName(), archiveEntry.getInputStream(), (OutputStream)outputStream);
                    outputStream.close();
                    if (!outputStream.isModified()) continue;
                    this.setFilePermission(archiveEntry, outputFile);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                entryProcessor.processed(entryName, outputFile);
            }
        }
        source.close();
    }

    private String adjustPath(boolean target, String entryName, UnarchivingEnhancedEntryProcessor entryProcessor) {
        if (!this.useRoot) {
            entryName = entryName.substring(entryName.indexOf(47) + 1);
        }
        entryName = target ? entryProcessor.targetName(entryName) : entryProcessor.sourceName(entryName);
        if (this.flatten) {
            entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
        }
        return entryName;
    }

    private void setFilePermission(ExtendedArchiveEntry archiveEntry, Path outputFile) throws IOException {
        int mode = archiveEntry.getFileMode();
        if (mode > 0) {
            this.setFilePermissions(outputFile, FileMode.toPermissionsSet(mode));
        } else if (archiveEntry.isDirectory()) {
            this.setFilePermissions(outputFile, PosixModes.intModeToPosix(493));
        } else {
            this.setFilePermissions(outputFile, PosixModes.intModeToPosix(420));
        }
    }

    private void setFilePermissions(Path file, Set<PosixFilePermission> perms) throws IOException {
        try {
            Files.setPosixFilePermissions(file, perms);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public static UnArchiverBuilder builder() {
        return new UnArchiverBuilder();
    }

    static class NoopEntryProcessor
    implements UnarchivingEnhancedEntryProcessor {
        NoopEntryProcessor() {
        }
    }

    public static class UnArchiverBuilder {
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();
        boolean useRoot = true;
        boolean flatten = false;
        boolean posixLongFileMode;
        boolean dereferenceHardlinks = false;

        public UnArchiverBuilder includes(String ... includes) {
            ArrayList<String> i = new ArrayList<String>();
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String include = stringArray[n2];
                if (include != null) {
                    i.add(include);
                }
                ++n2;
            }
            return this.includes(List.copyOf(i));
        }

        public UnArchiverBuilder includes(Iterable<String> includes) {
            includes.forEach(this.includes::add);
            return this;
        }

        public UnArchiverBuilder excludes(String ... excludes) {
            ArrayList<String> i = new ArrayList<String>();
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                if (exclude != null) {
                    i.add(exclude);
                }
                ++n2;
            }
            return this.excludes(List.copyOf(i));
        }

        public UnArchiverBuilder excludes(Iterable<String> excludes) {
            excludes.forEach(this.excludes::add);
            return this;
        }

        public UnArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public UnArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public UnArchiverBuilder posixLongFileMode(boolean posixLongFileMode) {
            this.posixLongFileMode = posixLongFileMode;
            return this;
        }

        public UnArchiverBuilder dereferenceHardlinks(boolean dereferenceHardlinks) {
            this.dereferenceHardlinks = dereferenceHardlinks;
            return this;
        }

        public UnArchiver build() {
            return new UnArchiver(this);
        }
    }
}

