/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.generator;

import ca.vanzyl.provisio.archive.generator.ArtifactEntry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public class ArtifactLayout {
    private final File tarGzDirectory;
    private final List<ArtifactEntry> entries;

    public ArtifactLayout(File tarGzDirectory) {
        this.tarGzDirectory = tarGzDirectory;
        this.entries = new ArrayList<ArtifactEntry>();
    }

    public ArtifactLayout(File tarGzDirectory, List<ArtifactEntry> entries) {
        this.tarGzDirectory = tarGzDirectory;
        this.entries = entries;
    }

    public ArtifactLayout entry(String name, File file) {
        this.entries.add(new ArtifactEntry(name, file));
        return this;
    }

    public ArtifactLayout entry(String name, String content) {
        this.entries.add(new ArtifactEntry(name, content));
        return this;
    }

    public void build() throws IOException {
        for (ArtifactEntry entry : this.entries) {
            File file = new File(this.tarGzDirectory, entry.name());
            if (entry.file() != null) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                Files.copy(entry.file().toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            if (entry.content() == null) continue;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Files.copy(new ByteArrayInputStream(entry.content().getBytes()), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public File directory() {
        return this.tarGzDirectory;
    }
}

