/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.source;

import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.source.FileEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.codehaus.plexus.util.DirectoryScanner;

public class DirectorySource
implements Source {
    private final File[] sourceDirectories;

    public DirectorySource(File ... sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    @Override
    public Iterable<ExtendedArchiveEntry> entries() {
        return () -> new DirectoryEntryIterator(this.sourceDirectories);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    static class DirectoryEntryIterator
    implements Iterator<ExtendedArchiveEntry> {
        final List<FileEntry> files = new ArrayList<FileEntry>();
        int currentFileIndex;

        DirectoryEntryIterator(File[] sourceDirectories) {
            File[] fileArray = sourceDirectories;
            int n = sourceDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceDirectory = fileArray[n2];
                String normalizedSourceDirectory = sourceDirectory.getName().replace('\\', '/');
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(sourceDirectory);
                scanner.setCaseSensitive(true);
                scanner.scan();
                Stream.of(scanner.getIncludedFiles(), scanner.getIncludedDirectories()).flatMap(stringArray -> Stream.of(stringArray)).sorted().forEach(f -> {
                    if (!f.isEmpty()) {
                        File file2 = new File(sourceDirectory, (String)f);
                        String archiveEntryName = normalizedSourceDirectory + "/" + f.replace('\\', '/');
                        this.files.add(new FileEntry(archiveEntryName, file2));
                    }
                });
                ++n2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentFileIndex != this.files.size();
        }

        @Override
        public ExtendedArchiveEntry next() {
            return this.files.get(this.currentFileIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }
}

