/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.tar;

import ca.vanzyl.provisio.archive.ArchiveHandlerSupport;
import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Selector;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.tar.ExtendedTarArchiveEntry;
import ca.vanzyl.provisio.archive.tar.TarGzXzArchiveSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class TarGzXzArchiveHandler
extends ArchiveHandlerSupport {
    private final File archive;
    private final boolean posixLongFileMode;
    private final Map<String, ExtendedArchiveEntry> processedFilesNames;
    private final Selector hardLinkSelector;

    public TarGzXzArchiveHandler(File archive, boolean posixLongFileMode, List<String> hardLinkIncludes, List<String> hardLinkExcludes) {
        this.archive = archive;
        this.posixLongFileMode = posixLongFileMode;
        this.processedFilesNames = new TreeMap<String, ExtendedArchiveEntry>();
        this.hardLinkSelector = !hardLinkIncludes.isEmpty() || !hardLinkExcludes.isEmpty() ? new Selector(hardLinkIncludes, hardLinkExcludes) : new Selector(null, List.of("**/**"));
    }

    @Override
    public ExtendedArchiveEntry newEntry(String entryName, ExtendedArchiveEntry entry) {
        ExtendedTarArchiveEntry tarArchiveEntry;
        if (this.hardLinkSelector.include(entryName)) {
            ExtendedArchiveEntry sourceToHardLink = this.processedFilesNames.get(this.fileNameOf(entry));
            if (sourceToHardLink != null) {
                ExtendedTarArchiveEntry tarArchiveEntry2 = new ExtendedTarArchiveEntry(entryName, 49);
                tarArchiveEntry2.setLinkName(sourceToHardLink.getName());
                return tarArchiveEntry2;
            }
            this.processedFilesNames.put(this.fileNameOf(entry), entry);
        }
        if ((tarArchiveEntry = new ExtendedTarArchiveEntry(entryName, entry)).isFile()) {
            tarArchiveEntry.setSize(entry.getSize());
        }
        return tarArchiveEntry;
    }

    @Override
    public ArchiveInputStream getInputStream() throws IOException {
        if (this.archive.getName().endsWith(".xz")) {
            return new TarArchiveInputStream((InputStream)new XZCompressorInputStream((InputStream)new FileInputStream(this.archive)));
        }
        return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(this.archive)));
    }

    @Override
    public ArchiveOutputStream getOutputStream() throws IOException {
        TarArchiveOutputStream stream = this.archive.getName().endsWith(".xz") ? new TarArchiveOutputStream((OutputStream)new XZCompressorOutputStream((OutputStream)new FileOutputStream(this.archive))) : new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(this.archive)));
        if (this.posixLongFileMode) {
            stream.setLongFileMode(3);
        }
        return stream;
    }

    @Override
    public Source getArchiveSource() {
        return new TarGzXzArchiveSource(this.archive);
    }

    private String fileNameOf(ExtendedArchiveEntry entry) {
        return entry.getName().substring(entry.getName().lastIndexOf(47) + 1);
    }
}

