/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.tar;

import ca.vanzyl.provisio.archive.ArchiverHelper;
import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.UnArchiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class TarGzXzArchiveSource
implements Source {
    private final ArchiveInputStream archiveInputStream;

    public TarGzXzArchiveSource(File archive) {
        try {
            this.archiveInputStream = ArchiverHelper.getArchiveHandler(archive, UnArchiver.builder()).getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot determine the type of archive %s.", archive), e);
        }
    }

    @Override
    public Iterable<ExtendedArchiveEntry> entries() {
        return () -> new ArchiveEntryIterator();
    }

    @Override
    public void close() throws IOException {
        this.archiveInputStream.close();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class ArchiveEntryIterator
    implements Iterator<ExtendedArchiveEntry> {
        TarArchiveEntry archiveEntry;

        ArchiveEntryIterator() {
        }

        @Override
        public ExtendedArchiveEntry next() {
            return new EntrySourceArchiveEntry(this.archiveEntry);
        }

        @Override
        public boolean hasNext() {
            try {
                this.archiveEntry = (TarArchiveEntry)TarGzXzArchiveSource.this.archiveInputStream.getNextEntry();
                return this.archiveEntry != null;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }

    class EntrySourceArchiveEntry
    implements ExtendedArchiveEntry {
        final TarArchiveEntry archiveEntry;

        public EntrySourceArchiveEntry(TarArchiveEntry archiveEntry) {
            this.archiveEntry = archiveEntry;
        }

        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return TarGzXzArchiveSource.this.archiveInputStream;
        }

        @Override
        public boolean isSymbolicLink() {
            return this.archiveEntry.isSymbolicLink();
        }

        @Override
        public String getSymbolicLinkPath() {
            return this.archiveEntry.getLinkName();
        }

        @Override
        public boolean isHardLink() {
            return this.archiveEntry.isLink();
        }

        @Override
        public String getHardLinkPath() {
            return this.archiveEntry.getLinkName();
        }

        public long getSize() {
            return this.archiveEntry.getSize();
        }

        @Override
        public void writeEntry(OutputStream outputStream) throws IOException {
            this.getInputStream().transferTo(outputStream);
        }

        @Override
        public void setFileMode(int mode) {
        }

        @Override
        public int getFileMode() {
            return this.archiveEntry.getMode();
        }

        @Override
        public void setSize(long size) {
        }

        @Override
        public void setTime(long time) {
        }

        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }

        public Date getLastModifiedDate() {
            return null;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public long getTime() {
            return this.archiveEntry.getModTime().getTime();
        }
    }
}

