/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.filelock.internal;

import io.tesla.filelock.FileLockManager;
import io.tesla.filelock.Lock;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultFileLockManager
implements FileLockManager {
    private Logger logger = LoggerFactory.getLogger(DefaultFileLockManager.class);
    private static final ConcurrentMap<File, LockFile> lockFiles = new ConcurrentHashMap<File, LockFile>(64);

    @Override
    public Lock readLock(File target) {
        return new IndirectFileLock(this.normalize(target), false);
    }

    @Override
    public Lock writeLock(File target) {
        return new IndirectFileLock(this.normalize(target), true);
    }

    private File normalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            this.logger.warn("Failed to normalize pathname for lock on " + file + ": " + e);
            return file.getAbsoluteFile();
        }
    }

    private boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    private RandomAccessFile open(File file, String mode) throws IOException {
        boolean interrupted = false;
        try {
            this.mkdirs(file.getParentFile());
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, mode);
            return randomAccessFile;
        }
        catch (IOException e) {
            for (int i = 3; i >= 0; --i) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    interrupted = true;
                }
                try {
                    RandomAccessFile e1 = new RandomAccessFile(file, mode);
                    return e1;
                }
                catch (IOException ie) {
                    continue;
                }
            }
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void close(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (this.logger == null) break block3;
                    this.logger.warn("Failed to close file: " + e);
                }
            }
        }
    }

    static /* synthetic */ void access$300(DefaultFileLockManager x0, Closeable x1) {
        x0.close(x1);
    }

    class LockFile {
        private final File dataFile;
        private final File lockFile;
        private FileLock fileLock;
        private RandomAccessFile raFile;
        private int refCount;
        private Thread owner;
        private final Map<Thread, AtomicInteger> clients = new HashMap<Thread, AtomicInteger>();

        public LockFile(File dataFile) {
            this.dataFile = dataFile;
            this.lockFile = dataFile.isDirectory() ? new File(dataFile, ".aetherlock") : new File(dataFile.getPath() + ".aetherlock");
        }

        public File getDataFile() {
            return this.dataFile;
        }

        public boolean lock(boolean write) throws IOException {
            if (this.isInvalid()) {
                throw new IllegalStateException("lock for " + this.dataFile + " has been invalidated");
            }
            if (this.isClosed()) {
                this.open(write);
                return true;
            }
            if (this.isReentrant(write)) {
                this.incRefCount();
                return true;
            }
            if (this.isAlreadyHoldByCurrentThread()) {
                throw new IllegalStateException("Cannot acquire " + (write ? "write" : "read") + " lock on " + this.dataFile + " for thread " + Thread.currentThread() + " which already holds incompatible lock");
            }
            return false;
        }

        public void unlock() throws IOException {
            if (this.decRefCount() <= 0) {
                this.close();
            }
        }

        FileLock getFileLock() {
            return this.fileLock;
        }

        public boolean isInvalid() {
            return this.refCount < 0;
        }

        public boolean isShared() {
            if (this.fileLock == null) {
                throw new IllegalStateException("lock not acquired");
            }
            return this.fileLock.isShared();
        }

        private boolean isClosed() {
            return this.fileLock == null;
        }

        private boolean isReentrant(boolean write) {
            if (this.isShared()) {
                return !write;
            }
            return Thread.currentThread() == this.owner;
        }

        private boolean isAlreadyHoldByCurrentThread() {
            return this.clients.get(Thread.currentThread()) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void open(boolean write) throws IOException {
            block13: {
                this.refCount = 1;
                this.owner = write != false ? Thread.currentThread() : null;
                this.clients.put(Thread.currentThread(), new AtomicInteger(1));
                raf = null;
                lock = null;
                interrupted = false;
                block8: while (true) {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        raf = DefaultFileLockManager.access$000(DefaultFileLockManager.this, this.lockFile, "rw");
                        try {
                            lock = raf.getChannel().lock(0L, 1L, write == false);
                            if (lock == null) {
                                throw new FileLockInterruptionException();
                            }
                            break block13;
                        }
                        catch (FileLockInterruptionException e) {
                            interrupted |= Thread.interrupted();
                            DefaultFileLockManager.access$300(DefaultFileLockManager.this, raf);
                        }
                        catch (IOException e) {
                            DefaultFileLockManager.access$300(DefaultFileLockManager.this, raf);
                            if (this.isPseudoDeadlock(e)) {
                                DefaultFileLockManager.access$100(DefaultFileLockManager.this).debug("OS detected pseudo deadlock for " + this.lockFile + ", retrying locking");
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e1) {
                                    interrupted = true;
                                    continue;
                                }
                                continue block8;
                            }
                            this.delete();
                            throw e;
                        }
                        break;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            this.raFile = raf;
            this.fileLock = lock;
        }

        private boolean isPseudoDeadlock(IOException e) {
            String msg = e.getMessage();
            return msg != null && msg.toLowerCase(Locale.ENGLISH).contains("deadlock");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() throws IOException {
            this.refCount = -1;
            if (this.fileLock != null) {
                try {
                    if (this.fileLock.isValid()) {
                        this.fileLock.release();
                    }
                }
                catch (IOException e) {
                    DefaultFileLockManager.this.logger.warn("Failed to release lock on " + this.lockFile + ": " + e);
                }
                finally {
                    this.fileLock = null;
                }
            }
            if (this.raFile != null) {
                try {
                    this.raFile.close();
                }
                finally {
                    this.raFile = null;
                    this.delete();
                }
            }
        }

        private void delete() {
            if (this.lockFile != null && !this.lockFile.delete() && this.lockFile.exists()) {
                this.lockFile.deleteOnExit();
            }
        }

        private int incRefCount() {
            AtomicInteger clientRefCount = this.clients.get(Thread.currentThread());
            if (clientRefCount == null) {
                this.clients.put(Thread.currentThread(), new AtomicInteger(1));
            } else {
                clientRefCount.incrementAndGet();
            }
            return ++this.refCount;
        }

        private int decRefCount() {
            AtomicInteger clientRefCount = this.clients.get(Thread.currentThread());
            if (clientRefCount != null && clientRefCount.decrementAndGet() <= 0) {
                this.clients.remove(Thread.currentThread());
            }
            return --this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    class IndirectFileLock
    implements Lock {
        private final File file;
        private final boolean write;
        private final Throwable stackTrace;
        private RandomAccessFile raFile;
        private LockFile lockFile;
        private int nesting;

        public IndirectFileLock(File file, boolean write) {
            this.file = file;
            this.write = write;
            this.stackTrace = new IllegalStateException();
        }

        @Override
        public synchronized void lock() throws IOException {
            if (this.lockFile == null) {
                this.open();
                this.nesting = 1;
            } else {
                ++this.nesting;
            }
        }

        @Override
        public synchronized void unlock() throws IOException {
            --this.nesting;
            if (this.nesting <= 0) {
                this.close();
            }
        }

        @Override
        public RandomAccessFile getRandomAccessFile() throws IOException {
            if (this.raFile == null && this.lockFile != null && this.lockFile.getFileLock().isValid()) {
                this.raFile = DefaultFileLockManager.this.open(this.file, this.write ? "rw" : "r");
            }
            return this.raFile;
        }

        @Override
        public boolean isShared() {
            if (this.lockFile == null) {
                throw new IllegalStateException("lock not acquired");
            }
            return this.lockFile.isShared();
        }

        @Override
        public FileLock getLock() {
            if (this.lockFile == null) {
                return null;
            }
            return this.lockFile.getFileLock();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.lockFile != null) {
                    DefaultFileLockManager.this.logger.warn("Lock on file " + this.file + " has not been properly released", this.stackTrace);
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void open() throws IOException {
            this.lockFile = this.lock(this.file, this.write);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() throws IOException {
            block16: {
                try {
                    if (this.raFile == null) break block16;
                    try {
                        this.raFile.close();
                    }
                    finally {
                        this.raFile = null;
                    }
                }
                finally {
                    if (this.lockFile != null) {
                        try {
                            this.unlock(this.lockFile);
                        }
                        catch (IOException e) {
                            DefaultFileLockManager.this.logger.warn("Failed to release lock for " + this.file + ": " + e);
                        }
                        finally {
                            this.lockFile = null;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LockFile lock(File file, boolean write) throws IOException {
            boolean interrupted = false;
            try {
                while (true) {
                    LockFile lockFile;
                    if ((lockFile = (LockFile)lockFiles.get(file)) == null) {
                        lockFile = new LockFile(file);
                        LockFile existing = lockFiles.putIfAbsent(file, lockFile);
                        if (existing != null) {
                            lockFile = existing;
                        }
                    }
                    LockFile lockFile2 = lockFile;
                    synchronized (lockFile2) {
                        if (lockFile.isInvalid()) {
                            continue;
                        }
                        if (lockFile.lock(write)) {
                            LockFile lockFile3 = lockFile;
                            return lockFile3;
                        }
                        try {
                            lockFile.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock(LockFile lockFile) throws IOException {
            LockFile lockFile2 = lockFile;
            synchronized (lockFile2) {
                try {
                    lockFile.unlock();
                }
                finally {
                    if (lockFile.isInvalid()) {
                        lockFiles.remove(lockFile.getDataFile(), lockFile);
                        lockFile.notifyAll();
                    }
                }
            }
        }
    }
}

