/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.jcabi.manifests.Manifests;
import com.sprylab.xar.XarEntry;
import com.sprylab.xar.XarFile;
import com.sprylab.xar.toc.ToCFactory;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.time.StopWatch;

public class Main {
    private static final String V_OPTION = "v";
    private static final String X_OPTION = "x";
    private static final String T_OPTION = "t";
    private static final String F_OPTION = "f";
    private static final String FILENAME_OPTION = "filename";
    private static final String DUMP_TOC_OPTION = "dump-toc";
    private static final String DUMP_HEADER_OPTION = "dump-header";
    private static final String VERSION_OPTION = "version";
    private static final String USAGE = "java -jar xar -[tx][v] -f <archive> ...";
    private static final String VERSION_MANIFEST_KEY = "Version";

    public static void main(String[] args) {
        Options options = Main.createCommandLineOptions();
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(F_OPTION)) {
                XarFile xarFile = new XarFile(new File(line.getOptionValue(F_OPTION)));
                if (line.hasOption(X_OPTION)) {
                    List argList = line.getArgList();
                    File destination = argList == null || argList.isEmpty() ? new File(Main.getWorkingDir()) : new File((String)argList.get(0));
                    XarFile.DEBUG = line.hasOption(V_OPTION);
                    Main.extractFiles(xarFile, destination);
                } else if (line.hasOption(T_OPTION)) {
                    Main.listEntries(xarFile);
                } else if (line.hasOption(DUMP_HEADER_OPTION)) {
                    Main.dumpHeader(xarFile);
                } else if (line.hasOption(DUMP_TOC_OPTION)) {
                    File tocFile = new File(line.getOptionValue(DUMP_TOC_OPTION));
                    Main.dumpToC(xarFile, tocFile);
                } else {
                    Main.printHelp(options);
                }
            } else if (line.hasOption(VERSION_OPTION)) {
                Main.printVersion();
            } else {
                Main.printHelp(options);
            }
        }
        catch (ParseException e) {
            Main.printHelp(options);
            System.err.println("Parsing failed.  Reason: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Opening xar file failed. Reason: " + e.getMessage());
        }
    }

    private static String getWorkingDir() {
        return System.getProperty("user.dir");
    }

    private static void extractFiles(XarFile xarFile, File destinationDir) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        xarFile.extractAll(destinationDir, false);
        stopWatch.stop();
        System.out.println("Took " + stopWatch.toString());
    }

    private static void listEntries(XarFile xarfile) {
        List<XarEntry> entries = xarfile.getEntries();
        for (XarEntry entry : entries) {
            System.out.println(entry.toString());
        }
    }

    private static void dumpHeader(XarFile xarFile) {
        XarFile.Header header = xarFile.getHeader();
        String headerStatus = header.hasValidMagic() ? "OK" : "INVALID";
        System.out.println(String.format("magic:\t\t\t\t\t%#x (%s)", header.getMagic().intValue(), headerStatus));
        System.out.println("size:\t\t\t\t\t" + header.getSize());
        System.out.println("version:\t\t\t\t" + header.getVersion());
        System.out.println("Compressed TOC length:\t" + header.getTocLengthCompressed());
        System.out.println("Uncompressed TOC length: " + header.getTocLengthUncompressed());
        int cksumAlg = header.getCksumAlg().intValue();
        System.out.println(String.format("Checksum algorithm:\t\t%d (%s)", new Object[]{cksumAlg, ChecksumAlgorithm.values()[cksumAlg]}));
    }

    private static void dumpToC(XarFile xarFile, File tocFile) {
        try {
            ToCFactory.copy(xarFile.getToCStream(), new FileOutputStream(tocFile));
        }
        catch (Exception e) {
            System.err.println("Failed dumping header. Reason: " + e.getMessage());
        }
    }

    private static Options createCommandLineOptions() {
        Option extract = new Option(X_OPTION, "Extracts an archive");
        Option list = new Option(T_OPTION, "Lists an archive");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)FILENAME_OPTION);
        OptionBuilder.withDescription((String)"Specifies an archive to operate on [REQUIRED!]");
        Option file = OptionBuilder.create((String)F_OPTION);
        OptionBuilder.withLongOpt((String)DUMP_TOC_OPTION);
        OptionBuilder.withArgName((String)FILENAME_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Has xar dump the xml header into the specified file.");
        Option dumpToc = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)DUMP_HEADER_OPTION);
        OptionBuilder.withDescription((String)"Prints out the xar binary header information");
        Option dumpHeader = OptionBuilder.create();
        Option verbose = new Option(V_OPTION, "Print filenames as they are archived");
        OptionBuilder.withLongOpt((String)VERSION_OPTION);
        OptionBuilder.withDescription((String)"Print xar's version number");
        Option version = OptionBuilder.create();
        Options options = new Options();
        options.addOption(extract);
        options.addOption(list);
        options.addOption(file);
        options.addOption(dumpToc);
        options.addOption(dumpHeader);
        options.addOption(verbose);
        options.addOption(version);
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(USAGE, options);
    }

    private static void printVersion() {
        System.out.println("xar " + Manifests.read((String)VERSION_MANIFEST_KEY));
        System.out.println("This is a port to pure Java.");
    }
}

