/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarFile;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.Data;
import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.toc.model.File;
import com.sprylab.xar.toc.model.SimpleChecksum;
import com.sprylab.xar.toc.model.Type;
import com.sprylab.xar.utils.FileAccessUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;

public class XarEntry {
    private String id;
    private String name;
    private boolean isDirectory;
    private List<XarEntry> children;
    private String mode;
    private String uid;
    private String user;
    private String gid;
    private String group;
    private Date time;
    private ChecksumAlgorithm checksumAlgorithm;
    private String checksum;
    private long size;
    private long offset;
    private long length;
    private Encoding encoding;
    private XarFile xarFile;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$sprylab$xar$toc$model$ChecksumAlgorithm;

    public static XarEntry createFromFile(XarFile xarFile, File file, String parentPath) {
        XarEntry xarEntry = new XarEntry();
        xarEntry.id = file.getId();
        String name = file.getName();
        if (StringUtils.isNotEmpty((CharSequence)parentPath)) {
            name = String.valueOf(parentPath) + "/" + name;
        }
        xarEntry.name = name;
        xarEntry.isDirectory = file.getType() == Type.DIRECTORY;
        xarEntry.mode = file.getMode();
        xarEntry.uid = file.getUid();
        xarEntry.user = file.getUser();
        xarEntry.gid = file.getGid();
        xarEntry.group = file.getGroup();
        xarEntry.time = file.getMtime();
        xarEntry.xarFile = xarFile;
        Data data = file.getData();
        if (data != null) {
            SimpleChecksum extractedChecksum = data.getExtractedChecksum() != null ? data.getExtractedChecksum() : data.getUnarchivedChecksum();
            xarEntry.checksumAlgorithm = extractedChecksum.getStyle();
            xarEntry.checksum = extractedChecksum.getValue();
            xarEntry.size = data.getSize();
            xarEntry.offset = xarFile.getHeader().getSize().longValue() + xarFile.getHeader().getTocLengthCompressed().longValue() + data.getOffset();
            xarEntry.length = data.getLength();
            xarEntry.encoding = data.getEncoding();
        }
        return xarEntry;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getMode() {
        return this.mode;
    }

    public String getUid() {
        return this.uid;
    }

    public String getUser() {
        return this.user;
    }

    public String getGid() {
        return this.gid;
    }

    public String getGroup() {
        return this.group;
    }

    public Date getTime() {
        return this.time;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public long getSize() {
        return this.size;
    }

    public List<XarEntry> getChildren() {
        return this.children;
    }

    void addChild(XarEntry childEntry) {
        if (this.children == null) {
            this.children = new ArrayList<XarEntry>();
        }
        this.children.add(childEntry);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isDirectory) {
            throw new IllegalStateException("Cannot get InputStream for entries of type directory.");
        }
        if (this.encoding == null) {
            return new NullInputStream(0L);
        }
        switch (this.encoding) {
            case NONE: {
                return FileAccessUtils.createLimitedBufferedInputStream(this.xarFile.getFile(), this.offset, this.length);
            }
            case GZIP: {
                return FileAccessUtils.createLimitedInflaterInputStream(this.xarFile.getFile(), this.offset, this.length);
            }
        }
        throw new UnsupportedEncodingException("Encoding not supported: " + this.encoding.name());
    }

    public byte[] getBytes() throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return new byte[0];
        }
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    public void extract(java.io.File fileOrDirectory) throws IOException {
        this.extract(fileOrDirectory, false);
    }

    public void extract(java.io.File fileOrDirectory, boolean check) throws IOException {
        this.extract(fileOrDirectory, check, null);
    }

    public void extract(java.io.File fileOrDirectory, boolean check, OnEntryExtractedListener listener) throws IOException {
        if (this.isDirectory) {
            List<XarEntry> entries = this.xarFile.getEntries();
            String directoryPath = this.name.concat("/");
            ArrayList<XarEntry> files = new ArrayList<XarEntry>();
            for (XarEntry entry : entries) {
                if (entry.getName().length() <= directoryPath.length() || !entry.getName().substring(0, directoryPath.length()).equals(directoryPath)) continue;
                files.add(entry);
            }
            for (XarEntry file : files) {
                file.extract(fileOrDirectory, check);
            }
        } else {
            java.io.File targetFile = fileOrDirectory.isFile() ? fileOrDirectory : new java.io.File(fileOrDirectory, this.name);
            FileUtils.forceMkdir((java.io.File)targetFile.getParentFile());
            InputStream data = this.getInputStream();
            try {
                FileUtils.copyInputStreamToFile((InputStream)data, (java.io.File)targetFile);
            }
            finally {
                IOUtils.closeQuietly((InputStream)data);
                if (check) {
                    this.checkExtractedFile(targetFile);
                }
                if (listener != null) {
                    listener.onEntryExtracted(this);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkExtractedFile(java.io.File targetFile) throws IOException {
        if (this.checksumAlgorithm == null && this.size == 0L) {
            return;
        }
        hash = null;
        var3_3 = null;
        var4_5 = null;
        try {
            targetFileInputStream = FileUtils.openInputStream((java.io.File)targetFile);
            try {
                switch (XarEntry.$SWITCH_TABLE$com$sprylab$xar$toc$model$ChecksumAlgorithm()[this.checksumAlgorithm.ordinal()]) {
                    case 2: {
                        hash = DigestUtils.sha1Hex((InputStream)targetFileInputStream);
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        hash = DigestUtils.md5Hex((InputStream)targetFileInputStream);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            finally {
                if (targetFileInputStream != null) {
                    targetFileInputStream.close();
                }
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
                throw var3_3;
            }
            if (var3_3 == var4_6) throw var3_3;
            var3_3.addSuppressed(var4_6);
            throw var3_3;
        }
        if (this.checksum.equals(hash) != false) return;
        throw new IOException("Hash of extracted file does match the stored checksum.");
    }

    public String toString() {
        return this.getName();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sprylab$xar$toc$model$ChecksumAlgorithm() {
        if ($SWITCH_TABLE$com$sprylab$xar$toc$model$ChecksumAlgorithm != null) {
            return $SWITCH_TABLE$com$sprylab$xar$toc$model$ChecksumAlgorithm;
        }
        int[] nArray = new int[ChecksumAlgorithm.values().length];
        try {
            nArray[ChecksumAlgorithm.MD5.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ChecksumAlgorithm.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ChecksumAlgorithm.SHA1.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sprylab$xar$toc$model$ChecksumAlgorithm = nArray;
        return nArray;
    }

    public static interface OnEntryExtractedListener {
        public void onEntryExtracted(XarEntry var1);
    }
}

