/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar;

import com.sprylab.xar.XarEntry;
import com.sprylab.xar.XarException;
import com.sprylab.xar.toc.ToCFactory;
import com.sprylab.xar.toc.model.File;
import com.sprylab.xar.toc.model.ToC;
import com.sprylab.xar.utils.FileAccessUtils;
import com.sprylab.xar.utils.FilePath;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joou.UInteger;
import org.joou.ULong;
import org.joou.UShort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XarFile {
    private static final Logger LOG = LoggerFactory.getLogger(XarFile.class);
    static boolean DEBUG = false;
    private final java.io.File file;
    private Header header;
    private final List<XarEntry> entries = new ArrayList<XarEntry>();
    private final Map<String, XarEntry> nameToEntryMap = new HashMap<String, XarEntry>();

    public XarFile(java.io.File file) throws XarException {
        this.file = file;
        this.checkXarFileHeader();
        this.createEntries();
    }

    private void checkXarFileHeader() throws XarException {
        this.header = new Header(this.file);
    }

    private void createEntries() throws XarException {
        InputStream inputStream = null;
        try {
            try {
                inputStream = this.getToCStream();
                ToC toC = ToCFactory.fromInputStream(inputStream);
                Stack<FilePath> fileStack = new Stack<FilePath>();
                fileStack.addAll(FilePath.fromFileList(toC.getFiles()));
                while (!fileStack.isEmpty()) {
                    List<File> children;
                    FilePath currentFile = (FilePath)fileStack.pop();
                    File fileEntry = currentFile.getFile();
                    XarEntry xarEntry = XarEntry.createFromFile(this, fileEntry, currentFile.getParentPath());
                    if (xarEntry.isDirectory() && (children = fileEntry.getChildren()) != null && !children.isEmpty()) {
                        fileStack.addAll(FilePath.fromFileList(children, xarEntry.getName()));
                    }
                    this.addEntry(xarEntry);
                    this.addToParentEntry(xarEntry, currentFile.getParentPath());
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new XarException("Error creating entries for " + this.file.toString(), e);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public InputStream getToCStream() throws IOException {
        return FileAccessUtils.createLimitedInflaterInputStream(this.file, this.header.getSize().longValue(), this.header.getTocLengthCompressed().longValue());
    }

    private void addEntry(XarEntry xarEntry) {
        this.entries.add(xarEntry);
        this.nameToEntryMap.put(xarEntry.getName(), xarEntry);
    }

    private void addToParentEntry(XarEntry xarEntry, String parentPath) {
        if (StringUtils.isEmpty((CharSequence)parentPath)) {
            return;
        }
        XarEntry parentEntry = this.getEntry(parentPath);
        parentEntry.addChild(xarEntry);
    }

    public List<XarEntry> getEntries() {
        return this.entries;
    }

    public XarEntry getEntry(String entryName) {
        return this.nameToEntryMap.get(entryName);
    }

    public boolean hasEntry(String entryName) {
        return this.nameToEntryMap.containsKey(entryName);
    }

    public long getSize() {
        return this.file.length();
    }

    public Header getHeader() {
        return this.header;
    }

    public java.io.File getFile() {
        return this.file;
    }

    public void extractAll(java.io.File directory) throws IOException {
        this.extractAll(directory, false);
    }

    public void extractAll(java.io.File directory, boolean check) throws IOException {
        this.extractAll(directory, check, null);
    }

    public void extractAll(java.io.File directory, boolean check, XarEntry.OnEntryExtractedListener listener) throws IOException {
        for (XarEntry entry : this.entries) {
            if (entry.isDirectory()) continue;
            if (DEBUG) {
                LOG.debug("Extract entry: {}", (Object)entry);
            }
            entry.extract(directory, check, listener);
        }
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public static class Header {
        private static final UInteger MAGIC = UInteger.valueOf((int)2019652129);
        private final UInteger magic;
        private final UShort size;
        private final UShort version;
        private final ULong tocLengthCompressed;
        private final ULong tocLengthUncompressed;
        private final UInteger cksumAlg;

        public Header(java.io.File file) throws XarException {
            RandomAccessFile randomAccessFile = null;
            try {
                try {
                    randomAccessFile = new RandomAccessFile(file, "r");
                    this.magic = UInteger.valueOf((int)randomAccessFile.readInt());
                    this.checkMagic();
                    this.size = UShort.valueOf((short)randomAccessFile.readShort());
                    this.version = UShort.valueOf((short)randomAccessFile.readShort());
                    this.tocLengthCompressed = ULong.valueOf((long)randomAccessFile.readLong());
                    this.tocLengthUncompressed = ULong.valueOf((long)randomAccessFile.readLong());
                    this.cksumAlg = UInteger.valueOf((int)randomAccessFile.readInt());
                }
                catch (IOException e) {
                    throw new XarException("Error opening XarFile", e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(randomAccessFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)randomAccessFile);
        }

        private void checkMagic() {
            if (!this.hasValidMagic()) {
                this.throwNoValidHeaderError();
            }
        }

        private void throwNoValidHeaderError() {
            throw new IllegalArgumentException("No valid xar header found.");
        }

        public boolean hasValidMagic() {
            return this.magic.equals((Object)MAGIC);
        }

        public UInteger getMagic() {
            return this.magic;
        }

        public UShort getSize() {
            return this.size;
        }

        public UShort getVersion() {
            return this.version;
        }

        public ULong getTocLengthCompressed() {
            return this.tocLengthCompressed;
        }

        public ULong getTocLengthUncompressed() {
            return this.tocLengthUncompressed;
        }

        public UInteger getCksumAlg() {
            return this.cksumAlg;
        }
    }
}

