/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.toc;

import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.DateTransform;
import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.toc.model.EncodingEnumTransform;
import com.sprylab.xar.toc.model.LowerCaseEnumTransform;
import com.sprylab.xar.toc.model.ToC;
import com.sprylab.xar.toc.model.Type;
import com.sprylab.xar.toc.model.Xar;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;
import org.simpleframework.xml.stream.Style;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.RegistryMatcher;
import org.simpleframework.xml.transform.Transform;

public class ToCFactory {
    private static Serializer SERIALIZER;

    private static Serializer getSerializer() {
        if (SERIALIZER == null) {
            HyphenStyle style = new HyphenStyle();
            Format format = new Format((Style)style);
            RegistryMatcher matcher = new RegistryMatcher();
            matcher.bind(Date.class, DateTransform.class);
            matcher.bind(ChecksumAlgorithm.class, (Transform)new LowerCaseEnumTransform(ChecksumAlgorithm.class));
            matcher.bind(Type.class, (Transform)new LowerCaseEnumTransform(Type.class));
            matcher.bind(Encoding.class, (Transform)new EncodingEnumTransform());
            SERIALIZER = new Persister((Matcher)matcher, format);
        }
        return SERIALIZER;
    }

    public static ToC fromFile(File source) throws Exception {
        Serializer serializer = ToCFactory.getSerializer();
        Xar xar = (Xar)serializer.read(Xar.class, source, false);
        return xar.getToc();
    }

    public static ToC fromInputStream(InputStream source) throws Exception {
        Serializer serializer = ToCFactory.getSerializer();
        Xar xar = (Xar)serializer.read(Xar.class, source, false);
        return xar.getToc();
    }

    public static void copy(InputStream source, OutputStream target) throws Exception {
        Serializer serializer = ToCFactory.getSerializer();
        Xar xar = (Xar)serializer.read(Xar.class, source, false);
        serializer.write((Object)xar, target);
    }

    public static void toOutputStream(Xar xar, OutputStream target) throws Exception {
        Serializer serializer = ToCFactory.getSerializer();
        serializer.write((Object)xar, target);
    }
}

