/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.toc.model;

import com.sprylab.xar.toc.model.Encoding;
import java.io.UnsupportedEncodingException;
import org.simpleframework.xml.transform.Transform;

public class EncodingEnumTransform
implements Transform<Encoding> {
    public static final String MIME_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_TYPE_GZIP = "application/x-gzip";
    public static final String MIME_TYPE_BZIP2 = "application/x-bzip";

    public Encoding read(String value) throws Exception {
        if (value.equals(MIME_TYPE_OCTET_STREAM)) {
            return Encoding.NONE;
        }
        if (value.equals(MIME_TYPE_GZIP)) {
            return Encoding.GZIP;
        }
        if (value.equals(MIME_TYPE_BZIP2)) {
            return Encoding.BZIP2;
        }
        return Encoding.NONE;
    }

    public String write(Encoding value) throws Exception {
        switch (value) {
            case GZIP: {
                return MIME_TYPE_GZIP;
            }
            case BZIP2: {
                return MIME_TYPE_BZIP2;
            }
            case NONE: {
                return MIME_TYPE_OCTET_STREAM;
            }
        }
        throw new UnsupportedEncodingException("Encoding not supported: " + value.name());
    }
}

