/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.utils;

import com.sprylab.xar.toc.model.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilePath {
    private final File file;
    private final String parentPath;

    public static List<FilePath> fromFileList(Collection<File> files) {
        return FilePath.fromFileList(files, "");
    }

    public static List<FilePath> fromFileList(Collection<File> files, String parentPath) {
        ArrayList<FilePath> filePaths = new ArrayList<FilePath>(files.size());
        for (File file : files) {
            filePaths.add(new FilePath(file, parentPath));
        }
        return filePaths;
    }

    public FilePath(File file, String parentPath) {
        this.file = file;
        this.parentPath = parentPath;
    }

    public File getFile() {
        return this.file;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        return this.file.getName();
    }
}

