/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.writer;

import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.Encoding;
import com.sprylab.xar.writer.XarContentProvider;
import com.sprylab.xar.writer.XarSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class XarFileSource
implements XarSource {
    private File file;
    private final File originalFile;
    private final boolean compress;
    private ChecksumAlgorithm checksumStyle = ChecksumAlgorithm.NONE;
    private String extractedChecksum;
    private final String archivedChecksum;

    public XarFileSource(File file) throws IOException {
        this(file, false);
    }

    public XarFileSource(File file, boolean compress) throws IOException {
        this(file, compress, ChecksumAlgorithm.NONE);
    }

    public XarFileSource(File file, boolean compress, ChecksumAlgorithm checksumStyle) throws IOException {
        this.file = file;
        this.originalFile = file;
        this.checksumStyle = checksumStyle;
        this.compress = compress;
        if (compress) {
            this.extractedChecksum = this.computeChecksum(file);
            File zipFile = File.createTempFile("xar-", ".gz");
            FileOutputStream fos = new FileOutputStream(zipFile);
            DeflaterOutputStream output = new DeflaterOutputStream(fos);
            FileInputStream input = new FileInputStream(file);
            IOUtils.copy((InputStream)input, (OutputStream)output);
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly((OutputStream)fos);
            this.file = zipFile;
        }
        this.archivedChecksum = this.computeChecksum(file);
        if (!compress) {
            this.extractedChecksum = this.archivedChecksum;
        }
    }

    private String computeChecksum(File targetFile) throws IOException {
        FileInputStream targetFileInpuStream = FileUtils.openInputStream((File)targetFile);
        switch (this.checksumStyle) {
            case SHA1: {
                return DigestUtils.sha1Hex((InputStream)targetFileInpuStream);
            }
            case MD5: {
                return DigestUtils.md5Hex((InputStream)targetFileInpuStream);
            }
        }
        return null;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public ChecksumAlgorithm getChecksumStyle() {
        return this.checksumStyle;
    }

    @Override
    public Encoding getEncoding() {
        return this.compress ? Encoding.GZIP : Encoding.NONE;
    }

    @Override
    public XarContentProvider getProvider() {
        return new XarContentProvider(){

            @Override
            public InputStream open() throws IOException {
                return new FileInputStream(XarFileSource.this.file);
            }

            @Override
            public void completed() {
                if (XarFileSource.this.compress) {
                    XarFileSource.this.file.delete();
                }
            }
        };
    }

    @Override
    public String getName() {
        return this.originalFile.getName();
    }

    @Override
    public long getSize() {
        return this.originalFile.length();
    }

    @Override
    public String getExtractedChecksum() {
        return this.extractedChecksum;
    }

    @Override
    public String getArchivedChecksum() {
        return this.archivedChecksum;
    }
}

