/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.writer;

import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.writer.XarDirectory;
import com.sprylab.xar.writer.XarFileSource;
import com.sprylab.xar.writer.XarSimpleDirectory;
import com.sprylab.xar.writer.XarWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class XarPacker {
    private static final Set<String> DEFAULT_PACK_EXTENSIONS = new HashSet<String>();
    private final File destFile;
    private final XarWriter writer;

    static {
        DEFAULT_PACK_EXTENSIONS.add("txt");
        DEFAULT_PACK_EXTENSIONS.add("htm");
        DEFAULT_PACK_EXTENSIONS.add("html");
        DEFAULT_PACK_EXTENSIONS.add("css");
        DEFAULT_PACK_EXTENSIONS.add("js");
        DEFAULT_PACK_EXTENSIONS.add("xml");
        DEFAULT_PACK_EXTENSIONS.add("stxml");
    }

    public XarPacker(String destFileName) {
        this.destFile = new File(destFileName);
        if (this.destFile.exists()) {
            this.destFile.delete();
        }
        this.writer = new XarWriter(ChecksumAlgorithm.SHA1);
    }

    public void addDirectory(File folder, boolean asSubFolder, Set<String> packedExtensions) throws Exception {
        XarSimpleDirectory root = null;
        if (asSubFolder) {
            root = new XarSimpleDirectory(folder.getName());
            this.writer.addDirectory(root, null);
        }
        this.addDirectoryContent(folder, root, packedExtensions == null ? DEFAULT_PACK_EXTENSIONS : null);
    }

    public void addDirectoryContent(File folder, XarDirectory parent, Set<String> packedExtensions) throws Exception {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                XarSimpleDirectory dir = new XarSimpleDirectory(f.getName());
                this.writer.addDirectory(dir, parent);
                this.addDirectoryContent(f, dir, packedExtensions);
            } else {
                int sep = f.getName().lastIndexOf(46);
                boolean compress = sep >= 0 && packedExtensions.contains(f.getName().substring(sep + 1));
                XarFileSource source = new XarFileSource(f, compress);
                this.writer.addSource(source, parent);
            }
            ++n2;
        }
    }

    public void write() throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.destFile);
            this.writer.write(fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 2) {
            System.out.println("Usage: XarPacker <directory> [<target-file>]");
            return;
        }
        File folder = new File(args[0]);
        if (!folder.isDirectory()) {
            System.out.println("Directory not found: " + args[0]);
            return;
        }
        String destFileName = args.length == 1 ? String.valueOf(args[0]) + ".xar" : args[1];
        try {
            XarPacker packer = new XarPacker(destFileName);
            packer.addDirectory(folder, false, null);
            packer.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

