/*
 * Decompiled with CFR 0.152.
 */
package com.sprylab.xar.writer;

import com.sprylab.xar.toc.ToCFactory;
import com.sprylab.xar.toc.model.Checksum;
import com.sprylab.xar.toc.model.ChecksumAlgorithm;
import com.sprylab.xar.toc.model.Data;
import com.sprylab.xar.toc.model.SimpleChecksum;
import com.sprylab.xar.toc.model.ToC;
import com.sprylab.xar.toc.model.Type;
import com.sprylab.xar.toc.model.Xar;
import com.sprylab.xar.writer.XarContentProvider;
import com.sprylab.xar.writer.XarDirectory;
import com.sprylab.xar.writer.XarSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class XarWriter {
    private static final int MAGIC = 2019652129;
    private static final short HEADER_SIZE = 28;
    private static final short VERSION = 1;
    private static final int CHECKSUM_LENGTH_MD5 = 16;
    private static final int CHECKSUM_LENGTH_SHA1 = 40;
    private ChecksumAlgorithm checksumAlgorithm;
    private final Xar xarRoot = new Xar();
    private final List<com.sprylab.xar.toc.model.File> fileList = new ArrayList<com.sprylab.xar.toc.model.File>();
    private final List<XarSource> sources = new ArrayList<XarSource>();
    private final Map<XarDirectory, com.sprylab.xar.toc.model.File> dirMap = new HashMap<XarDirectory, com.sprylab.xar.toc.model.File>();
    private long currentOffset;
    private int id = 0;

    public XarWriter() {
        this(ChecksumAlgorithm.SHA1);
    }

    public XarWriter(ChecksumAlgorithm checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
        int checkSumLength = checksumAlgorithm == ChecksumAlgorithm.MD5 ? 16 : (checksumAlgorithm == ChecksumAlgorithm.SHA1 ? 40 : 0);
        ToC toc = new ToC();
        toc.setCreationTime(new Date());
        this.xarRoot.setToc(toc);
        toc.setFiles(this.fileList);
        Checksum checksum = new Checksum();
        toc.setChecksum(checksum);
        checksum.setStyle(checksumAlgorithm);
        checksum.setSize(checkSumLength);
        checksum.setOffset(0L);
        this.currentOffset = checkSumLength;
    }

    public void addSource(XarSource source, XarDirectory parent) {
        this.sources.add(source);
        com.sprylab.xar.toc.model.File file = new com.sprylab.xar.toc.model.File();
        file.setType(Type.FILE);
        file.setName(source.getName());
        file.setId(String.valueOf(this.id++));
        Data data = new Data();
        data.setOffset(this.currentOffset);
        data.setLength(source.getLength());
        data.setSize(source.getSize());
        this.currentOffset += source.getLength();
        SimpleChecksum extractedChecksum = new SimpleChecksum();
        extractedChecksum.setStyle(source.getChecksumStyle());
        extractedChecksum.setValue(source.getExtractedChecksum() == null ? "0" : source.getExtractedChecksum());
        data.setExtractedChecksum(extractedChecksum);
        data.setUnarchivedChecksum(extractedChecksum);
        SimpleChecksum archivedChecksum = new SimpleChecksum();
        archivedChecksum.setStyle(source.getChecksumStyle());
        archivedChecksum.setValue(source.getArchivedChecksum() == null ? "0" : source.getArchivedChecksum());
        data.setArchivedChecksum(archivedChecksum);
        data.setEncoding(source.getEncoding());
        file.setData(data);
        this.addFile(file, parent);
    }

    public void addDirectory(XarDirectory dir, XarDirectory parent) {
        com.sprylab.xar.toc.model.File file = new com.sprylab.xar.toc.model.File();
        file.setType(Type.DIRECTORY);
        file.setName(dir.getName());
        file.setId(String.valueOf(this.id++));
        this.addFile(file, parent);
        this.dirMap.put(dir, file);
    }

    private void addFile(com.sprylab.xar.toc.model.File file, XarDirectory parent) {
        if (parent == null) {
            this.fileList.add(file);
        } else {
            com.sprylab.xar.toc.model.File parentFile = this.dirMap.get(parent);
            if (parentFile == null) {
                throw new IllegalArgumentException("parent unknown");
            }
            List<com.sprylab.xar.toc.model.File> children = parentFile.getChildren();
            if (children == null) {
                children = new ArrayList<com.sprylab.xar.toc.model.File>();
                parentFile.setChildren(children);
            }
            children.add(file);
        }
    }

    public void write(OutputStream output) throws Exception {
        File tocFile = File.createTempFile("xar", ".toc");
        FileOutputStream fos = new FileOutputStream(tocFile);
        ToCFactory.toOutputStream(this.xarRoot, fos);
        IOUtils.closeQuietly((OutputStream)fos);
        File compressedTocFile = File.createTempFile("xar", ".toc.gz");
        fos = new FileOutputStream(compressedTocFile);
        DeflaterOutputStream os = new DeflaterOutputStream(fos);
        FileInputStream fis = new FileInputStream(tocFile);
        IOUtils.copy((InputStream)fis, (OutputStream)os);
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((OutputStream)fos);
        output.write(this.createHeader(compressedTocFile.length(), tocFile.length()));
        fis = new FileInputStream(compressedTocFile);
        IOUtils.copy((InputStream)fis, (OutputStream)output);
        IOUtils.closeQuietly((InputStream)fis);
        if (this.checksumAlgorithm != ChecksumAlgorithm.NONE) {
            byte[] hash;
            FileInputStream compressedTocFileInputStream = FileUtils.openInputStream((File)compressedTocFile);
            switch (this.checksumAlgorithm) {
                case MD5: {
                    hash = DigestUtils.md5((InputStream)compressedTocFileInputStream);
                    break;
                }
                default: {
                    hash = DigestUtils.sha1((InputStream)compressedTocFileInputStream);
                }
            }
            output.write(hash);
        }
        for (XarSource xs : this.sources) {
            XarContentProvider provider = xs.getProvider();
            InputStream inputStream = provider.open();
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            IOUtils.closeQuietly((InputStream)inputStream);
            provider.completed();
        }
    }

    private byte[] createHeader(long tocLengthCompressed, long tocLengthUnCompressed) {
        ByteBuffer bb = ByteBuffer.allocate(28);
        bb.putInt(0, 2019652129);
        bb.putShort(4, (short)28);
        bb.putShort(6, (short)1);
        bb.putLong(8, tocLengthCompressed);
        bb.putLong(16, tocLengthUnCompressed);
        bb.putInt(24, this.checksumAlgorithm.ordinal());
        return bb.array();
    }
}

