/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.allure.cucumberjvm;

import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.config.AllureModelUtils;
import ru.yandex.qatools.allure.events.StepCanceledEvent;
import ru.yandex.qatools.allure.events.StepEvent;
import ru.yandex.qatools.allure.events.StepFailureEvent;
import ru.yandex.qatools.allure.events.StepFinishedEvent;
import ru.yandex.qatools.allure.events.StepStartedEvent;
import ru.yandex.qatools.allure.events.TestCaseCanceledEvent;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFailureEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCasePendingEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.utils.AnnotationManager;

public class AllureCucumberListener
extends RunListener {
    private Allure lifecycle = Allure.LIFECYCLE;
    private final Map<String, String> suites = new HashMap<String, String>();
    private Description parentDescription;

    public void testRunStarted(Description description) {
        this.parentDescription = description;
    }

    public void testStarted(Description description) throws IllegalAccessException {
        if (description.isTest()) {
            String stepName = this.extractMethodName(description);
            this.getLifecycle().fire(new StepStartedEvent(stepName).withTitle(stepName));
        } else {
            String scenarioName = description.getClassName();
            if (scenarioName.startsWith("|") || description.getDisplayName().endsWith("|")) {
                scenarioName = this.getScenarioOutlineName(description) + " " + scenarioName;
            }
            scenarioName = scenarioName.replaceFirst("^(.*): ", "");
            TestCaseStartedEvent event = new TestCaseStartedEvent(this.getSuiteUid(description), scenarioName);
            event.setTitle(scenarioName);
            Stories story = this.getStoriesAnnotation(new String[]{scenarioName});
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (Annotation annotation : description.getAnnotations()) {
                annotations.add(annotation);
            }
            annotations.add((Annotation)story);
            AnnotationManager am = new AnnotationManager(annotations);
            am.update(event);
            this.getLifecycle().fire(event);
        }
    }

    public void testFailure(Failure failure) {
        Throwable throwable = failure.getException();
        if (failure.getDescription().isTest()) {
            this.getLifecycle().fire((StepEvent)new StepFailureEvent().withThrowable(throwable));
        } else if (throwable instanceof AssumptionViolatedException) {
            this.getLifecycle().fire((TestCaseEvent)new TestCaseCanceledEvent().withThrowable(throwable));
        } else {
            this.getLifecycle().fire((TestCaseEvent)new TestCaseFailureEvent().withThrowable(throwable));
        }
    }

    public void testAssumptionFailure(Failure failure) {
        this.testFailure(failure);
    }

    public void testIgnored(Description description) throws IllegalAccessException {
        if (description.isTest()) {
            String stepName = this.extractMethodName(description);
            this.getLifecycle().fire(new StepStartedEvent(stepName).withTitle(stepName));
            this.getLifecycle().fire((StepEvent)new StepCanceledEvent());
            this.getLifecycle().fire(new StepFinishedEvent());
        } else {
            this.getLifecycle().fire((TestCaseEvent)new TestCasePendingEvent().withMessage(this.getIgnoredMessage(description)));
        }
    }

    public void testFinished(Description description) throws IllegalAccessException {
        if (description.isTest()) {
            this.getLifecycle().fire(new StepFinishedEvent());
        } else {
            this.getLifecycle().fire(new TestCaseFinishedEvent());
            if (this.isLastScenario(description)) {
                this.getLifecycle().fire(new TestSuiteFinishedEvent(this.getSuiteUid(description)));
            }
        }
    }

    private List<Description> findFeaturesLevel(List<Description> description) throws IllegalAccessException {
        if (description.isEmpty()) {
            return new ArrayList<Description>();
        }
        Object entityType = this.getTestEntityType(description.get(0));
        if (entityType instanceof Feature) {
            return description;
        }
        return this.findFeaturesLevel(description.get(0).getChildren());
    }

    private Object getTestEntityType(Description description) throws IllegalAccessException {
        return FieldUtils.readField((Object)description, (String)"fUniqueId", (boolean)true);
    }

    private List<Description> findTestClassesLevel(List<Description> description) throws IllegalAccessException {
        if (description.isEmpty()) {
            return new ArrayList<Description>();
        }
        Object possibleClass = this.getTestEntityType(description.get(0));
        if (possibleClass instanceof String && !((String)possibleClass).isEmpty()) {
            if (!description.get(0).getChildren().isEmpty()) {
                Object possibleFeature = this.getTestEntityType((Description)description.get(0).getChildren().get(0));
                if (possibleFeature instanceof Feature) {
                    return description;
                }
                return this.findTestClassesLevel(description.get(0).getChildren());
            }
            return description;
        }
        return this.findTestClassesLevel(description.get(0).getChildren());
    }

    private void testSuiteStarted(String suiteName) throws IllegalAccessException {
        String uid = this.generateSuiteUid(suiteName);
        String featureName = suiteName.replaceFirst("^(.*): ", "");
        Features feature = this.getFeaturesAnnotation(new String[]{featureName});
        TestSuiteStartedEvent event = new TestSuiteStartedEvent(uid, featureName);
        event.setTitle(featureName);
        AnnotationManager am = new AnnotationManager(new Annotation[]{feature});
        am.update(event);
        event.withLabels(AllureModelUtils.createTestFrameworkLabel((String)"CucumberJVM"), new Label[0]);
        this.getLifecycle().fire((TestSuiteEvent)event);
    }

    private String getScenarioOutlineName(Description description) throws IllegalAccessException {
        Object testEntityType = this.getTestEntityType(description);
        if (testEntityType instanceof Scenario) {
            return ((Scenario)testEntityType).getName();
        }
        return "Undefined Scenario Outline";
    }

    private boolean isLastScenario(Description description) throws IllegalAccessException {
        return this.getLastScenarioIds().contains(this.getScenarioId(description));
    }

    private String findFeatureByScenario(Description scenario) throws IllegalAccessException {
        String scenarioToFindId = this.getScenarioId(scenario);
        List<Description> testClasses = this.findTestClassesLevel(this.parentDescription.getChildren());
        for (Description testClass : testClasses) {
            List<Description> features = this.findFeaturesLevel(testClass.getChildren());
            for (Description feature : features) {
                for (Description story : feature.getChildren()) {
                    Object scenarioType = this.getTestEntityType(story);
                    if (scenarioType instanceof Scenario && ((Scenario)scenarioType).getId().equals(scenarioToFindId)) {
                        return feature.getDisplayName();
                    }
                    if (!(scenarioType instanceof ScenarioOutline)) continue;
                    ArrayList examples = ((Description)story.getChildren().get(0)).getChildren();
                    for (Description example : examples) {
                        Object exampleType = this.getTestEntityType(example);
                        if (!(exampleType instanceof Scenario) || !((Scenario)exampleType).getId().equals(scenarioToFindId)) continue;
                        return feature.getDisplayName();
                    }
                }
            }
        }
        return "Feature: Undefined Feature";
    }

    private List<String> getLastScenarioIds() throws IllegalAccessException {
        ArrayList<String> ids = new ArrayList<String>();
        List<Description> testClasses = this.findTestClassesLevel(this.parentDescription.getChildren());
        for (Description testClass : testClasses) {
            List<Description> features = this.findFeaturesLevel(testClass.getChildren());
            for (Description feature : features) {
                ArrayList examples;
                Description lastExample;
                Object exampleType;
                Description lastScenarioDescription = (Description)feature.getChildren().get(feature.getChildren().size() - 1);
                Object scenarioType = this.getTestEntityType(lastScenarioDescription);
                if (scenarioType instanceof Scenario) {
                    ids.add(((Scenario)scenarioType).getId());
                    continue;
                }
                if (!(scenarioType instanceof ScenarioOutline) || !((exampleType = this.getTestEntityType(lastExample = (Description)(examples = ((Description)lastScenarioDescription.getChildren().get(0)).getChildren()).get(examples.size() - 1))) instanceof Scenario)) continue;
                ids.add(((Scenario)exampleType).getId());
            }
        }
        return ids;
    }

    private String getScenarioId(Description description) throws IllegalAccessException {
        String id = description.getClassName();
        Object scenarioToFindType = this.getTestEntityType(description);
        if (scenarioToFindType instanceof Scenario) {
            id = ((Scenario)scenarioToFindType).getId();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSuiteUid(String suiteName) {
        String uid = UUID.randomUUID().toString();
        Map<String, String> map = this.getSuites();
        synchronized (map) {
            this.getSuites().put(suiteName, uid);
        }
        return uid;
    }

    private String getSuiteUid(Description description) throws IllegalAccessException {
        String suiteName = this.findFeatureByScenario(description);
        if (!this.getSuites().containsKey(suiteName)) {
            this.testSuiteStarted(suiteName);
        }
        return this.getSuites().get(suiteName);
    }

    private String getIgnoredMessage(Description description) {
        Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
        return ignore == null || ignore.value().isEmpty() ? "Step is not implemented yet!" : ignore.value();
    }

    private Allure getLifecycle() {
        return this.lifecycle;
    }

    private Map<String, String> getSuites() {
        return this.suites;
    }

    private String extractMethodName(Description description) {
        String displayName = description.getDisplayName();
        Pattern pattern = Pattern.compile("^(.*)\\(\\|");
        Matcher matcher = pattern.matcher(displayName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return description.getMethodName();
    }

    private Stories getStoriesAnnotation(final String[] value) {
        return new Stories(){

            public String[] value() {
                return value;
            }

            public Class<Stories> annotationType() {
                return Stories.class;
            }
        };
    }

    private Features getFeaturesAnnotation(final String[] value) {
        return new Features(){

            public String[] value() {
                return value;
            }

            public Class<Features> annotationType() {
                return Features.class;
            }
        };
    }
}

