/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api;

import io.netty.handler.ssl.SslContext;
import io.tarantool.driver.api.connection.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.api.connection.TarantoolConnectionSelectionStrategies;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.factories.DefaultMessagePackMapperFactory;
import io.tarantool.driver.utils.Assert;
import java.util.concurrent.atomic.AtomicBoolean;

public class TarantoolClientConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT = 1000;
    private static final int DEFAULT_READ_TIMEOUT = 1000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 2000;
    private static final int DEFAULT_CONNECTIONS = 1;
    private static final int DEFAULT_CURSOR_BATCH_SIZE = 100;
    private static final int DEFAULT_EVENT_LOOP_THREADS_NUMBER = 0;
    private TarantoolCredentials credentials;
    private int connectTimeout = 1000;
    private int readTimeout = 1000;
    private int requestTimeout = 2000;
    private int connections = 1;
    private int eventLoopThreadsNumber = 0;
    private MessagePackMapper messagePackMapper = DefaultMessagePackMapperFactory.getInstance().defaultComplexTypesMapper();
    private ConnectionSelectionStrategyFactory connectionSelectionStrategyFactory = TarantoolConnectionSelectionStrategies.ParallelRoundRobinStrategyFactory.INSTANCE;
    private final AtomicBoolean isSecure = new AtomicBoolean(false);
    private SslContext sslContext;

    public TarantoolClientConfig() {
    }

    public TarantoolClientConfig(TarantoolClientConfig config) {
        this.connectionSelectionStrategyFactory = config.getConnectionSelectionStrategyFactory();
        this.messagePackMapper = config.getMessagePackMapper();
        this.connectTimeout = config.getConnectTimeout();
        this.requestTimeout = config.getRequestTimeout();
        this.credentials = config.getCredentials();
        this.readTimeout = config.getReadTimeout();
        this.connections = config.getConnections();
        this.isSecure.set(config.isSecure.get());
        this.sslContext = config.getSslContext();
        this.eventLoopThreadsNumber = config.getEventLoopThreadsNumber();
    }

    public TarantoolCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(TarantoolCredentials credentials) {
        this.credentials = credentials;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public void setSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        this.isSecure.set(true);
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean isSecure() {
        return this.isSecure.get();
    }

    public void setSecure(boolean isSecure) {
        this.isSecure.set(isSecure);
    }

    public MessagePackMapper getMessagePackMapper() {
        return this.messagePackMapper;
    }

    public void setMessagePackMapper(MessagePackMapper messagePackMapper) {
        this.messagePackMapper = messagePackMapper;
    }

    public ConnectionSelectionStrategyFactory getConnectionSelectionStrategyFactory() {
        return this.connectionSelectionStrategyFactory;
    }

    public void setConnectionSelectionStrategyFactory(ConnectionSelectionStrategyFactory connectionSelectionStrategyFactory) {
        this.connectionSelectionStrategyFactory = connectionSelectionStrategyFactory;
    }

    public int getCursorBatchSize() {
        return 100;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getEventLoopThreadsNumber() {
        return this.eventLoopThreadsNumber;
    }

    public void setEventLoopThreadsNumber(int eventLoopThreadsNumber) {
        this.eventLoopThreadsNumber = eventLoopThreadsNumber;
    }

    public static final class Builder {
        private TarantoolClientConfig config;

        public Builder() {
            this.config = new TarantoolClientConfig();
        }

        public Builder(TarantoolClientConfig config) {
            this.config = config;
        }

        public Builder withCredentials(TarantoolCredentials credentials) {
            Assert.notNull(credentials, "Tarantool server credentials should not be null");
            this.config.setCredentials(credentials);
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            Assert.state(readTimeout > 0, "Response reading timeout should be greater than 0");
            this.config.setReadTimeout(readTimeout);
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            Assert.state(connectTimeout > 0, "Connection timeout should be greater than 0");
            this.config.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder withRequestTimeout(int requestTimeout) {
            Assert.state(requestTimeout > 0, "Request timeout should be greater than 0");
            this.config.setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder withMessagePackMapper(MessagePackMapper mapper) {
            Assert.notNull(mapper, "MessagePack mapper should not be null");
            this.config.setMessagePackMapper(mapper);
            return this;
        }

        public Builder withConnections(int connections) {
            Assert.state(connections > 0, "The number of server connections must be greater than 0");
            this.config.setConnections(connections);
            return this;
        }

        public Builder withSslContext(SslContext sslContext) {
            Assert.notNull(sslContext, "SslContext must not be null");
            this.config.setSslContext(sslContext);
            return this;
        }

        public Builder withSecure(boolean isSecure) {
            Assert.notNull(this.config.getSslContext(), "SslContext must not be null");
            this.config.setSecure(isSecure);
            return this;
        }

        public Builder withConnectionSelectionStrategyFactory(ConnectionSelectionStrategyFactory factory) {
            Assert.notNull(factory, "Connection selection strategy factory must not be null");
            this.config.setConnectionSelectionStrategyFactory(factory);
            return this;
        }

        public Builder withEventLoopThreadsNumber(int eventLoopThreadsNumber) {
            Assert.state(eventLoopThreadsNumber > 0, "EventLoopThreadsNumber should be equals or greater than 0");
            this.config.setEventLoopThreadsNumber(eventLoopThreadsNumber);
            return this;
        }

        public TarantoolClientConfig build() {
            if (this.config.getCredentials() == null) {
                this.config.setCredentials(new SimpleTarantoolCredentials());
            }
            return new TarantoolClientConfig(this.config);
        }

        public Builder clear() {
            this.config = new TarantoolClientConfig();
            return this;
        }
    }
}

